/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.output;

import hu.metainf.logger.api.Logger;
import hu.metainf.plugin.confluence.contentexporter.ContentExporterException;
import hu.metainf.plugin.confluence.contentexporter.exporter.Bookmarks;
import hu.metainf.plugin.confluence.contentexporter.exporter.Images;
import hu.metainf.plugin.confluence.contentexporter.exporter.VelocityTemplate;
import hu.metainf.plugin.confluence.contentexporter.exporter.io.IoUtil;
import hu.metainf.plugin.confluence.contentexporter.exporter.output.FileBasedOutputWriter;
import hu.metainf.plugin.confluence.contentexporter.model.ConfluencePage;
import hu.metainf.plugin.confluence.contentexporter.model.Formatting;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class DocWriter
extends FileBasedOutputWriter {
    private static final Logger logger = Logger.getLogger(DocWriter.class);
    private static final String PAGE_BREAK_TEMPLATE = "<br style='mso-special-character:line-break;page-break-after:always;display:block' class='%s'/>";

    public DocWriter(Formatting formatting, Bookmarks bookmarks, List<? extends ConfluencePage> pages) {
        super(formatting, bookmarks, pages, null);
    }

    @Override
    public void customizeDocumentPrefix(VelocityTemplate template) {
        File cssFile = new File(this.exportContext.getWorkingDirectory(), "combined.css");
        try {
            template.put("wordCss", IoUtil.read(cssFile));
        }
        catch (IOException e) {
            logger.warn("Can't read combined CSS file: {}", new Object[]{cssFile});
        }
    }

    @Override
    public String getPageTitle(String bookmarkId, String pageTitle, int pageHierarchicalLevel) {
        return "<a name='" + bookmarkId + "'></a><h1>" + pageTitle + "</h1>";
    }

    @Override
    public File convert(File sourceFile) throws ContentExporterException {
        try {
            Images images = this.exportContext.getImages();
            File workingDirectory = this.exportContext.getWorkingDirectory();
            File outputFile = this.createOutputFile(sourceFile, "doc");
            Session session = Session.getInstance((Properties)new Properties(), null);
            MimeMessage message = new MimeMessage(session);
            MimeMultipart mpart = new MimeMultipart("related");
            MimeBodyPart bodypart = new MimeBodyPart();
            bodypart.setDataHandler(new DataHandler((DataSource)new FileDataSource(sourceFile.getAbsolutePath())));
            bodypart.setHeader("Content-Type", "text/html; charset=UTF-8");
            bodypart.setHeader("Content-Transfer-Encoding", "quoted-printable");
            bodypart.setHeader("Content-Location", "file:///C:/export.html");
            mpart.addBodyPart((BodyPart)bodypart);
            for (String imageFilename : images.getImageFilenameList()) {
                if (imageFilename.isEmpty()) continue;
                int p = imageFilename.lastIndexOf(46);
                String extension = imageFilename.substring(p + 1);
                MimeBodyPart imgpart = new MimeBodyPart();
                imgpart.setDataHandler(new DataHandler((DataSource)new FileDataSource(workingDirectory + "/" + imageFilename)));
                imgpart.addHeader("Content-Type", "image/" + extension);
                imgpart.addHeader("Content-Transfer-Encoding", "base64");
                imgpart.addHeader("Content-Location", "file:///C:/" + imageFilename);
                mpart.addBodyPart((BodyPart)imgpart);
            }
            this.addInlineStyles(mpart);
            message.setContent((Multipart)mpart);
            try (FileOutputStream fos = new FileOutputStream(outputFile);){
                message.writeTo((OutputStream)fos);
            }
            return outputFile;
        }
        catch (IOException | MessagingException exception) {
            throw new ContentExporterException(exception);
        }
    }

    private void addInlineStyles(MimeMultipart mpart) throws MessagingException {
        MimeBodyPart stylesPart = new MimeBodyPart();
        File inlineStyles = this.getInlineStyles();
        stylesPart.setDataHandler(new DataHandler((DataSource)new FileDataSource(inlineStyles)));
        String fileName = inlineStyles.getName();
        stylesPart.addHeader("Content-Type", "text/css; charset=utf-8; name=" + fileName);
        stylesPart.addHeader("Content-Transfer-Encoding", "8bit");
        stylesPart.addHeader("Content-Location", "file:///C:/" + fileName);
        mpart.addBodyPart((BodyPart)stylesPart);
    }

    @Override
    protected String getPageBreakTemplate() {
        return PAGE_BREAK_TEMPLATE;
    }

    @Override
    public void addSectionBreak(String pageClass) throws IOException {
        this.addPageBreak(pageClass);
    }
}

