/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.output;

import hu.metainf.logger.api.Logger;
import hu.metainf.plugin.confluence.contentexporter.ContentExporterException;
import hu.metainf.plugin.confluence.contentexporter.exporter.ExportContext;
import hu.metainf.plugin.confluence.contentexporter.exporter.HtmlCleanerFactory;
import hu.metainf.plugin.confluence.contentexporter.exporter.VelocityTemplate;
import hu.metainf.plugin.confluence.contentexporter.exporter.io.BufferedFileWriter;
import hu.metainf.plugin.confluence.contentexporter.exporter.output.OutputWriter;
import hu.metainf.plugin.confluence.contentexporter.model.ConfluencePage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.XmlSerializer;

public abstract class AbstractOutputWriter
implements OutputWriter {
    private static final Logger logger = Logger.getLogger(AbstractOutputWriter.class);
    protected ExportContext exportContext;
    protected final List<? extends ConfluencePage> pages;
    protected Integer totalPageCount = 0;
    protected boolean isPageCountingActive = false;
    protected boolean isPageCountingFinished = false;
    private XmlSerializer serializer;

    protected AbstractOutputWriter(List<? extends ConfluencePage> pages) {
        this.pages = pages;
    }

    @Override
    public void init(ExportContext exportContext) throws IOException {
        this.exportContext = exportContext;
        this.serializer = HtmlCleanerFactory.getXmlSerializer();
    }

    @Override
    public void resetTotalPageCount() {
        this.totalPageCount = 0;
        this.isPageCountingFinished = false;
    }

    @Override
    public long getTotalPageCount() {
        return this.totalPageCount.intValue();
    }

    @Override
    public boolean doWeNeedSecondRound() {
        return false;
    }

    @Override
    public void customizeDocumentPrefix(VelocityTemplate template) {
    }

    @Override
    public void addTableOfContents() throws ContentExporterException {
    }

    @Override
    public String getBookmarks() throws ContentExporterException {
        return "";
    }

    @Override
    public String getLinkPrefix(long pageId) {
        return this.exportContext.getOutputFormat().getLinkPrefix(pageId);
    }

    @Override
    public void saveInlineStyles() throws IOException {
        File file = this.getInlineStyles();
        if (!file.exists() && !file.createNewFile()) {
            logger.error("Could not create inline_styles.css: {}", new Object[]{file.getAbsolutePath()});
            return;
        }
        try (FileWriter fos = new FileWriter(file);){
            for (Map.Entry<String, String> entry : this.exportContext.getStyles().entrySet()) {
                fos.write("/* " + entry.getKey() + " */\n");
                fos.write(entry.getValue() + "\n");
            }
        }
        catch (IOException ioException) {
            logger.error("IO error when saving inline styles", (Throwable)ioException);
        }
    }

    protected File getInlineStyles() {
        return new File(this.exportContext.getWorkingDirectory(), "inline_styles.css");
    }

    protected File createOutputFile(File sourceFile, String extension) {
        if (sourceFile.isDirectory()) {
            return new File(this.exportContext.getWorkingDirectory(), sourceFile.getName() + "." + extension);
        }
        String filename = sourceFile.getAbsolutePath();
        return new File(filename.substring(0, filename.length() - "html".length()) + extension);
    }

    @Override
    public void addPageNumbersStartFromSection() throws IOException {
    }

    @Override
    public void addSectionBreak(String pageClass) throws IOException {
    }

    @Override
    public void closePageNumbersStartFromSection() throws IOException {
    }

    protected void write(BufferedFileWriter intermediateHtmlWriter, String title, String body) throws IOException {
        intermediateHtmlWriter.println("<div class='wiki-title'>");
        intermediateHtmlWriter.println(title);
        intermediateHtmlWriter.println("</div>");
        intermediateHtmlWriter.println("<div class='wiki-content'>");
        intermediateHtmlWriter.println(body);
        intermediateHtmlWriter.println("</div>");
    }

    String getBody(TagNode rootNode) {
        String body;
        TagNode bodyNode = rootNode.findElementByName("body", true);
        if (!bodyNode.isEmpty()) {
            body = this.serializer.getAsString(bodyNode);
            body = body.substring(7, body.length() - 7);
        } else {
            body = "";
        }
        return body;
    }
}

