/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

public class HttpUtil {
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTPS_PREFIX = "https://";

    public static boolean isAbsoluteUrl(String url) {
        return url.startsWith(HTTP_PREFIX) || url.startsWith(HTTPS_PREFIX);
    }

    public static String extractDomainAndProtocol(String url) {
        int p = url.indexOf(47, HTTPS_PREFIX.length());
        return p > 0 ? url.substring(0, p) : url;
    }

    public static InputStream openConnectionCheckRedirects(String url) throws IOException {
        return HttpUtil.openConnectionCheckRedirects(url, Collections.emptyMap());
    }

    public static InputStream openConnectionCheckRedirects(String url, Map<String, String> headers) throws IOException {
        URL u = new URL(url);
        HttpURLConnection c = (HttpURLConnection)u.openConnection();
        c.setInstanceFollowRedirects(false);
        boolean isRedirect = true;
        int redirectCount = 0;
        InputStream in = null;
        while (isRedirect) {
            if (headers != null) {
                for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
                    c.setRequestProperty(headerEntry.getKey(), headerEntry.getValue());
                }
            }
            c.setDoInput(true);
            c.connect();
            in = c.getInputStream();
            int stat = c.getResponseCode();
            isRedirect = stat == 302 || stat == 301 || stat == 303;
            if (!isRedirect) continue;
            if (++redirectCount >= 5) {
                throw new IOException("Too many HTTP redirects: " + url);
            }
            URL base = c.getURL();
            String location = c.getHeaderField("Location");
            URL target = null;
            if (location != null) {
                target = new URL(base, location);
            }
            c.disconnect();
            if (target == null) {
                throw new IOException("Missing HTTP redirect target: " + url);
            }
            String protocol = target.getProtocol();
            if (!"http".equals(protocol) && !"https".equals(protocol)) {
                throw new IOException("Invalid HTTP redirect protocol: " + protocol + " for " + url);
            }
            c = (HttpURLConnection)target.openConnection();
        }
        return in;
    }

    public static String encodeURIComponent(String s) {
        String result;
        try {
            result = URLEncoder.encode(s, "UTF-8").replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            result = s;
        }
        return result;
    }

    public static void setNoCacheHeaders(HttpServletResponse response) {
        response.setHeader("Cache-Control", "private, must-revalidate, max-age=5");
        response.setHeader("Pragma", "");
        response.setDateHeader("Expires", System.currentTimeMillis());
    }

    public static String encodeQueryParams(String uri) throws MalformedURLException, UnsupportedEncodingException {
        if (!uri.contains("?")) {
            return uri;
        }
        HashMap<String, String> encodedParams = new HashMap<String, String>();
        URL url = new URL(uri);
        String query = url.getQuery();
        if (query != null) {
            String[] params;
            for (String param : params = query.split("&")) {
                String[] split = param.split("=");
                encodedParams.put(split[0], URLEncoder.encode(split[1], StandardCharsets.UTF_8.name()));
            }
        }
        String file = url.getProtocol() + "://" + url.getHost() + ":" + url.getPort() + url.getPath();
        if (!encodedParams.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = encodedParams.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                stringBuilder.append((String)next.getKey()).append("=").append((String)next.getValue());
                if (!iterator.hasNext()) continue;
                stringBuilder.append("&");
            }
            file = file + "?" + stringBuilder.toString();
        }
        return file;
    }
}

