/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class IoUtil {
    public static void copy(InputStream inputStream, File destinationFile) throws IOException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(destinationFile);
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    public static void copy(File sourceFile, OutputStream outputStream) throws IOException {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(sourceFile);
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    public static String read(InputStream inputStream) throws IOException {
        try {
            String string = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public static String read(File file) throws IOException {
        String string;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            string = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return string;
    }
}

