function initCreateGlobalCoversPage(){
    if(AJS.Meta.get('render-mode')=="READ_ONLY"){
        AJS.$("#create-global-space").disable();
    }
    AJS.$("#create-global-space").on('click', function(e) {
        if(AJS.Meta.get('access-mode') != "READ_ONLY"){
            var container = AJS.$("#cex-covers-missing-bar");
            var disabledControls = MIJS.disableControls(container.find("button"));
            var spinner = MIJS.startSpin(container);

            AJS.$.ajax({
                url: AJS.contextPath() + "/plugins/contentexporter/cover-pages/create-global-space.action",
                type: "POST",
                cache: false,
            }).always(function(){
                MIJS.stopSpin(spinner);
                MIJS.enableControls(disabledControls);
            }).done(function(data){
                AJS.log("create global covers space result: " + JSON.stringify(data));
                if (data.status === "invalid-data") {
                    AJS.log("global templates space could not be created: " + JSON.stringify(data.errors));
                    AJS.$(".aui-message.error").remove();
                    AJS.messages.error("#cex-covers-message-bar", {
                        title:"Error",
                        body: "<p>Some error occurred when tried to create space for global cover pages.</p>" +
                        "<p>Please contact your admin and check logs.</p>"
                    });
                }
                else {
                    AJS.$("#cex-covers-missing-bar").remove();
                    AJS.messages.success("#cex-covers-message-bar", {
                        title:"Success",
                        body: "<p>Space for global cover pages successfully created</p>"
                    });
                    AJS.$(document).on("aui-message-close", function (e,a) {
                        AJS.$("#cex-covers-message-bar").remove()
                    });
                }
            });
            }
        })
}
function initAddProfileButton () {
    AJS.$("#add-profile-button").on('click', function(e) {
        e.preventDefault();
        var addProfileContainer = AJS.$("#add-profile");
        var disabledControls = MIJS.disableControls(addProfileContainer.find("button"));
        var spinner = MIJS.startSpin(addProfileContainer);

        var pluginUrl = AJS.contextPath() + "/plugins/contentexporter";
        if (AJS.$("#spaceKey").val())
        {
            var data = {key: AJS.$("#spaceKey").val()};
            var url= pluginUrl + "/profiles/newSpaceProfile.action";
        }
        else {
            var url = pluginUrl + "/profiles/newGlobalProfile.action";
        }
        AJS.$.ajax({
            url: url,
            type: "GET",
            dataType: "json",
            data: data,
            cache: false
        }).done(function(newProfile){
            AJS.$.ajax({
                url: pluginUrl + "/profiles/edit-dialog.action",
                type: "GET",
                dataType: "html"
            }).always(function(){
                MIJS.enableControls(disabledControls);
                MIJS.stopSpin(spinner);
            }).done(function(exportProfileDialog){
                AJS.log("new profile dialog");
                var container = AJS.$("#content-exporter-profile-container");
                if (container.length > 0) {
                    container.empty();
                }
                else {
                    container = AJS.$("<div id='content-exporter-profile-container' style='display: none'></div>");
                    AJS.$("body").append(container);
                }
                container.append(exportProfileDialog);
                initProfileDialog(newProfile)
            }).fail(function(jqXHR, textStatus, errorThrown){
                alert("Can not create new Export Profile!");
                AJS.log("Start Export Profile error: " + textStatus + ", " + errorThrown);
            });
        }).fail(function(){
            MIJS.enableControls(disabledControls);
            MIJS.stopSpin(spinner);
            alert("Can not initialize Content Exporter!");
        });
    });
}

function initProfileDialog(profile) {
    var pluginUrl = AJS.contextPath() + "/plugins/contentexporter";

    AJS.CONTENT_EXPORTER.PROFILE.init(profile, {
        width: 900,
        height: 680,
        mode: "edit",
        params: {},
        urls:{
            save: pluginUrl + "/profiles/save.action",
            coverPageSearch: pluginUrl + "/cover-pages/search.action",
            coverPageLoad: pluginUrl + "/cover-pages/load.action"
        },
        onClose: function(dialog) {
            if(dialog.action === "save"){
                location.reload();
            }
            else{
                AJS.$("#export-profile-container").remove();
                AJS.CONTENT_EXPORTER.PROFILE.removeAllDialogs();
            }
        }
    });
}

function initDeleteProfileButtons() {
    var deleteConfirmationDialogTemplate = AJS.$("#cex-delete-profile-confirmation-dialog-template").remove();
 if(AJS.Meta.get('render-mode')=="READ_ONLY"){
            AJS.$(".delete-profile").disable();
    }
    AJS.$(".delete-profile").click(function(event) {
        if(AJS.Meta.get('access-mode') != "READ_ONLY"){
            event.preventDefault();

            var target = AJS.$(this);
            var profileId = target.data("profile-id");
            var profileName = target.data("profile-name");
            var spinner = MIJS.startSpin(target.parent());

            var content = deleteConfirmationDialogTemplate.clone();
            content.find("#profile-name").text(profileName);

            var confirmationDialog = new AJS.Dialog({
                width: 600,
                height: 200,
                id: "cex-confirmation-dialog"
            });
            confirmationDialog.addHeader("Confirmation");
            confirmationDialog.addPanel("", content);
            confirmationDialog.addButton("OK", function() {
                confirmationDialog.remove();
                deleteProfile(profileId);
            });
            confirmationDialog.addCancel("Cancel", function (dialog) {
                confirmationDialog.remove();
            });

            confirmationDialog.show();
            MIJS.stopSpin(spinner);
        }
    });
}
function deleteProfile(id){
    AJS.$.ajax({
        url: AJS.contextPath() + "/plugins/contentexporter/profiles/delete.action?id=" + id,
        method: "DELETE",
        timeout: 180000, // 3 minutes
        cache: false,
        dataType: "json",
        success: function() {
            location.reload();
        },
        error: function(jqXHR, textStatus, errorThrown) {
            AJS.CONTENT_EXPORTER.showError(AJS.CONTENT_EXPORTER.createErrorMessage("Sorry, can not delete profile!", jqXHR));
            AJS.log("Save profile error: " + textStatus + ", " + errorThrown);
        }
    });
}

function initEditProfileButtons() {
    AJS.$(".edit-profile").click(function(event) {
        event.preventDefault();
        var target = AJS.$(this);
        var addProfileContainer = target.parent();
        var spinner = MIJS.startSpin(addProfileContainer);
        var profileId = target.data("profile-id");
        AJS.log("edit profile: " + profileId);
        var pluginUrl = AJS.contextPath() + "/plugins/contentexporter";

        AJS.$.ajax({
            url: pluginUrl + "/profiles/load.action",
            type: "GET",
            dataType: "json",
            data: {id:profileId},
            cache: false
        }).done(function (profile){
            AJS.$.ajax({
                url: pluginUrl + "/profiles/edit-dialog.action",
                type: "GET",
                dataType: "html"
            }).always(function (){
                MIJS.stopSpin(spinner);
            }).done(function(exportProfileDialog){
                AJS.log("edit profile dialog");
                var container = AJS.$("#content-exporter-profile-container");
                if (container.length > 0) {
                    container.empty();
                }
                else {
                    container = AJS.$("<div id='content-exporter-profile-container' style='display: none'></div>");
                    AJS.$("body").append(container);
                }
                container.append(exportProfileDialog);
                initProfileDialog(profile)
            }).fail(function(jqXHR, textStatus, errorThrown){
                alert("Can not edit Export Profile!");
                AJS.log("Edit Export Profile error: " + textStatus + ", " + errorThrown);
            });
        }).fail(function(){
            MIJS.stopSpin(spinner);
            alert("Can not initialize Content Exporter!");
        });
    });
}
