/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.model.filter;

import hu.metainf.logger.api.Logger;
import hu.metainf.plugin.confluence.contentexporter.model.ConfluenceContent;
import hu.metainf.plugin.confluence.contentexporter.model.ConfluenceLabel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class LabelFilter {
    private static final Logger logger = Logger.getLogger(LabelFilter.class);
    private Set<String> labels = null;

    public LabelFilter(String labels) {
        if (labels != null) {
            this.labels = new HashSet<String>(Arrays.asList(StringUtils.split((String)labels, (String)" ,")));
        }
    }

    public boolean accept(ConfluenceContent content) {
        return content != null && (this.labels == null || this.isMatchingLabels(content));
    }

    private boolean isMatchingLabels(ConfluenceContent content) {
        Set<ConfluenceLabel> contentLabels = content.getLabels();
        logger.debug("Labels attached for page id: {} are {}", new Object[]{content.getId(), contentLabels});
        if (contentLabels != null) {
            for (ConfluenceLabel label : contentLabels) {
                if (!this.labels.contains(label.getName())) continue;
                logger.debug("Label match for page id: {} results true", new Object[]{content.getId()});
                return true;
            }
        }
        logger.debug("Label match for page id: {} results false", new Object[]{content.getId()});
        return false;
    }
}

