/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import hu.metainf.plugin.confluence.contentexporter.model.ExportType;
import hu.metainf.plugin.confluence.contentexporter.model.Formatting;
import hu.metainf.plugin.confluence.contentexporter.model.HeaderFooter;
import hu.metainf.plugin.confluence.contentexporter.model.Margin;
import hu.metainf.plugin.confluence.contentexporter.model.OutputFormat;
import hu.metainf.plugin.confluence.contentexporter.model.PageNumbersArea;
import hu.metainf.plugin.confluence.contentexporter.model.PageSettings;
import hu.metainf.plugin.confluence.contentexporter.model.TocMode;
import hu.metainf.plugin.confluence.contentexporter.model.Unit;
import java.util.ArrayList;
import java.util.List;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ExportParameters {
    @JsonProperty(value="contentId")
    private Long rootContentId;
    @JsonProperty(value="format")
    private OutputFormat outputFormat = OutputFormat.PDF;
    @JsonProperty(value="content")
    private List<Long> selectedContentIdList = new ArrayList<Long>();
    @JsonProperty(value="exportContentType")
    private ExportType exportType = ExportType.PAGE;
    @JsonProperty(value="labels")
    private String labels;
    @JsonProperty(value="frontCover")
    private Long frontCover;
    @JsonProperty(value="backCover")
    private Long backCover;
    @JsonProperty(value="toc")
    private boolean tableOfContents;
    @JsonProperty(value="tocTitle")
    private String tocTitle = "Table of Contents";
    @JsonProperty(value="tocLevel")
    private int tocLevel = 6;
    @JsonProperty(value="tocMode")
    private TocMode tocMode = TocMode.FLAT;
    @JsonProperty(value="pageNumbersArea")
    private PageNumbersArea pageNumbersArea = new PageNumbersArea();
    @JsonProperty(value="stylesheetId")
    private long stylesheetId;
    @JsonProperty(value="headerFooters")
    private List<HeaderFooter> headerFooters = new ArrayList<HeaderFooter>();
    @JsonProperty(value="pageSettings")
    private PageSettings pageSettings = PageSettings.DEFAULT;
    @JsonProperty(value="unit")
    private Unit unit = Unit.IN;
    @JsonProperty(value="margins")
    private List<Margin> margins = new ArrayList<Margin>(){
        {
            this.add(Margin.DEFAULT);
        }
    };
    @JsonProperty(value="profileId")
    private Long profileId;
    @JsonProperty(value="customProfileName")
    private String customProfileName;
    @JsonProperty(value="fontResize")
    private boolean fontResize = true;
    @JsonProperty(value="breakWord")
    private boolean breakWord;
    @JsonProperty(value="separatePage")
    private boolean separatePage = true;
    @JsonProperty(value="selectedFont")
    private Long selectedFont;
    @JsonProperty(value="additionalFonts")
    private Long[] additionalFonts;
    @JsonProperty(value="headingNumbering")
    private boolean headingNumbering;

    public ExportParameters() {
    }

    public ExportParameters(Long contentId, OutputFormat outputFormat) {
        this.rootContentId = contentId;
        this.outputFormat = outputFormat;
    }

    public Long getRootContentId() {
        return this.rootContentId;
    }

    public OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    public List<Long> getSelectedContentIdList() {
        return this.selectedContentIdList;
    }

    public ExportType getExportType() {
        return this.exportType;
    }

    public String getLabels() {
        return this.labels;
    }

    public boolean isTableOfContents() {
        return this.tableOfContents;
    }

    public boolean hasSelectedContent() {
        return this.exportType == ExportType.TREE && this.selectedContentIdList != null && !this.selectedContentIdList.isEmpty();
    }

    public long getStylesheetId() {
        return this.stylesheetId;
    }

    public void setStylesheetId(long stylesheetId) {
        this.stylesheetId = stylesheetId;
    }

    public List<HeaderFooter> getHeaderFooters() {
        return this.headerFooters;
    }

    public Formatting getFormatting() {
        Formatting formatting = new Formatting();
        formatting.setFrontCover(this.frontCover);
        formatting.setBackCover(this.backCover);
        formatting.setTableOfContents(this.tableOfContents);
        formatting.setTocTitle(this.tocTitle);
        formatting.setTocLevel(this.tocLevel);
        formatting.setTocMode(this.tocMode);
        formatting.setPageNumbersArea(this.pageNumbersArea);
        formatting.setStylesheetId(this.stylesheetId);
        formatting.setHeaderFooters(this.headerFooters);
        formatting.setPageSettings(this.pageSettings);
        formatting.setUnit(this.unit);
        formatting.setMargins(this.margins);
        formatting.setFontResize(this.fontResize);
        formatting.setBreakWord(this.breakWord);
        formatting.setSeparatePage(this.separatePage);
        formatting.setSelectedFont(this.selectedFont);
        formatting.setAdditionalFonts(this.additionalFonts);
        formatting.setHeadingNumbering(this.headingNumbering);
        return formatting;
    }

    public void setMargins(List<Margin> margins) {
        this.margins = margins;
    }

    public List<Margin> getMargins() {
        return this.margins;
    }

    public PageSettings getPageSettings() {
        return this.pageSettings;
    }

    public void setPageSettings(PageSettings pageSettings) {
        this.pageSettings = pageSettings;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public void setProfileId(Long profileId) {
        this.profileId = profileId;
    }

    public Long getProfileId() {
        return this.profileId;
    }

    public String getCustomProfileName() {
        return this.customProfileName;
    }

    public void setCustomProfileName(String customProfileName) {
        this.customProfileName = customProfileName;
    }

    public void setFrontCover(Long frontCover) {
        this.frontCover = frontCover;
    }

    public Long getFrontCover() {
        return this.frontCover;
    }

    public Long getBackCover() {
        return this.backCover;
    }

    public void setBackCover(Long backCover) {
        this.backCover = backCover;
    }

    public boolean isFrontCover() {
        return this.frontCover != null;
    }

    public boolean isBackCover() {
        return this.backCover != null;
    }

    public void setTableOfContents(boolean tableOfContents) {
        this.tableOfContents = tableOfContents;
    }

    public void setTocLevel(int tocLevel) {
        this.tocLevel = tocLevel;
    }

    public int getTocLevel() {
        return this.tocLevel;
    }

    public TocMode getTocMode() {
        return this.tocMode;
    }

    public void setTocMode(TocMode tocMode) {
        this.tocMode = tocMode;
    }

    public PageNumbersArea getPageNumbersArea() {
        return this.pageNumbersArea;
    }

    public void setPageNumbersArea(PageNumbersArea pageNumbersArea) {
        this.pageNumbersArea = pageNumbersArea;
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        this.outputFormat = outputFormat;
    }

    public void setFontResize(boolean fontResize) {
        this.fontResize = fontResize;
    }

    public boolean isFontResize() {
        return this.fontResize;
    }

    public void setBreakWord(boolean breakWord) {
        this.breakWord = breakWord;
    }

    public boolean isBreakWord() {
        return this.breakWord;
    }

    public boolean isSeparatePage() {
        return this.separatePage;
    }

    public void setSeparatePage(boolean separatePage) {
        this.separatePage = separatePage;
    }

    public String getTocTitle() {
        return this.tocTitle;
    }

    public void setTocTitle(String tocTitle) {
        this.tocTitle = tocTitle;
    }

    public Long getSelectedFont() {
        return this.selectedFont;
    }

    public void setSelectedFont(Long selectedFont) {
        this.selectedFont = selectedFont;
    }

    public Long[] getAdditionalFonts() {
        return this.additionalFonts;
    }

    public void setAdditionalFonts(Long[] additionalFonts) {
        this.additionalFonts = additionalFonts;
    }

    public boolean isHeadingNumbering() {
        return this.headingNumbering;
    }

    public void setHeadingNumbering(boolean headingNumbering) {
        this.headingNumbering = headingNumbering;
    }
}

