/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.output;

import hu.metainf.logger.api.Logger;
import hu.metainf.plugin.confluence.contentexporter.dao.FontRepository;
import hu.metainf.plugin.confluence.contentexporter.exporter.ExportContext;
import hu.metainf.plugin.confluence.contentexporter.exporter.ResourceLoader;
import hu.metainf.plugin.confluence.contentexporter.exporter.io.IoUtil;
import hu.metainf.plugin.confluence.contentexporter.exporter.output.PdfWriter;
import hu.metainf.plugin.confluence.contentexporter.model.Font;
import hu.metainf.plugin.confluence.contentexporter.model.FontFile;
import hu.metainf.plugin.confluence.contentexporter.model.Formatting;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.xhtmlrenderer.pdf.ITextFontResolver;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class PdfFontHandler {
    private static final Logger logger = Logger.getLogger(PdfWriter.class);
    private static final String FONT_FAMILY_ARIAL = "Arial";
    private static final String FONT_FAMILY_COURIER_NEW = "Courier New";
    private static final String FONT_FAMILY_TIMES_NEW_ROMAN = "Times New Roman";
    private final List<FontName> DEFAULT_EXTRA_FONTS = this.generateFontNames(new String[][]{{"Courier New", "Cousine-Bold.ttf"}, {"Courier New", "Cousine-BoldItalic.ttf"}, {"Courier New", "Cousine-Italic.ttf"}, {"Courier New", "Cousine-Regular.ttf"}, {"Times New Roman", "Tinos-Bold.ttf"}, {"Times New Roman", "Tinos-BoldItalic.ttf"}, {"Times New Roman", "Tinos-Italic.ttf"}, {"Times New Roman", "Tinos-Regular.ttf"}, {"Atlassian Icons", "Atlassian-icons.ttf"}, {"Symbol", "SymbolNeu.ttf"}});
    private final List<FontName> DEFAULT_ARIAL_FONTS = this.generateFontNames(new String[][]{{"Arial", "SourceSansPro-Bold.ttf"}, {"Arial", "SourceSansPro-BoldIt.ttf"}, {"Arial", "SourceSansPro-It.ttf"}, {"Arial", "SourceSansPro-Regular.ttf"}});
    private final FontRepository fontRepository;
    private final ExportContext exportContext;

    public PdfFontHandler(FontRepository fontRepository, ExportContext exportContext) {
        this.fontRepository = fontRepository;
        this.exportContext = exportContext;
    }

    public boolean addFonts(ITextRenderer renderer, Formatting formatting) {
        List<FontName> fontsList = this.getFontsList(formatting);
        return this.addFontsToPdf(renderer, fontsList);
    }

    synchronized List<FontName> getFontsList(Formatting formatting) {
        ArrayList<FontName> fontsList = new ArrayList<FontName>();
        if (formatting.getSelectedFont() != null) {
            fontsList.addAll(this.copyCustomFont(formatting.getSelectedFont(), FONT_FAMILY_ARIAL));
        }
        if (fontsList.size() == 0) {
            fontsList.addAll(this.copyDefaultFonts(this.DEFAULT_ARIAL_FONTS));
        }
        fontsList.addAll(this.copyDefaultFonts(this.DEFAULT_EXTRA_FONTS));
        if (formatting.getAdditionalFonts() != null) {
            Long[] longArray = formatting.getAdditionalFonts();
            int n = longArray.length;
            for (int i = 0; i < n; ++i) {
                long id = longArray[i];
                fontsList.addAll(this.copyCustomFont(id, null));
            }
        }
        return fontsList;
    }

    private List<FontName> copyCustomFont(Long fontId, String cssName) {
        ArrayList<FontName> result = new ArrayList<FontName>();
        Font font = (Font)this.fontRepository.getById(fontId);
        if (font == null) {
            logger.info("Selected font (id: {}) does not exist", new Object[]{fontId});
            return result;
        }
        List<FontFile> files = font.getFiles();
        if (files.isEmpty()) {
            logger.info("Selected font (id: {}) has no attached file", new Object[]{fontId});
            return result;
        }
        for (FontFile file : files) {
            FontName customFontListElement;
            block8: {
                File fontFile = this.openFile(file);
                String string = cssName = cssName == null ? font.getCssName() : cssName;
                if (StringUtils.isEmpty((String)cssName)) {
                    logger.debug("No valid cssName found (font: {}).", new Object[]{font.getName()});
                    continue;
                }
                customFontListElement = new FontName(cssName, fontFile.getName());
                if (!fontFile.exists() || fontFile.length() == 0L) {
                    byte[] content = file.getFontData();
                    try {
                        IoUtil.copy(new ByteArrayInputStream(content), fontFile);
                        break block8;
                    }
                    catch (IOException e) {
                        logger.error("Could not copy the file: {}", new Object[]{file.getFileName(), e});
                        continue;
                    }
                }
                if (!fontFile.setLastModified(System.currentTimeMillis())) {
                    logger.error("Could not update last modified time for font file: {}", new Object[]{fontFile.getAbsolutePath()});
                }
            }
            result.add(customFontListElement);
        }
        return result;
    }

    private File openFile(FontFile fontFile) {
        String fileName = fontFile.getHash() + "_" + fontFile.getFileName();
        return new File(this.exportContext.getTempDirectory(), fileName);
    }

    private boolean addFontsToPdf(ITextRenderer renderer, List<FontName> fontsList) {
        ITextFontResolver fontResolver = renderer.getFontResolver();
        for (FontName font : fontsList) {
            String fontFamilyOverrideName = font.getCssName();
            String fontFilename = font.getFileName();
            String path = new File(this.exportContext.getTempDirectory(), fontFilename).getAbsolutePath();
            try {
                fontResolver.addFont(path, fontFamilyOverrideName, "Identity-H", true, null);
            }
            catch (Exception e) {
                logger.error("Can't load font!", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private List<FontName> copyDefaultFonts(List<FontName> fontsArray) {
        ArrayList<FontName> result = new ArrayList<FontName>();
        ResourceLoader resourceLoader = this.exportContext.getResourceLoader();
        File tempDirectory = this.exportContext.getTempDirectory();
        for (FontName font : fontsArray) {
            String fontFilename = font.getFileName();
            try {
                File fontFile = new File(tempDirectory, fontFilename);
                if (!fontFile.exists() || fontFile.length() == 0L) {
                    InputStream is = resourceLoader.resolveFont(fontFilename);
                    IoUtil.copy(is, fontFile);
                }
                result.add(font);
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Could not open fontFile: {}", new Object[]{fontFilename, e});
            }
        }
        return result;
    }

    private List<FontName> generateFontNames(String[][] fontNameArray) {
        ArrayList<FontName> result = new ArrayList<FontName>();
        for (String[] aFontArray : fontNameArray) {
            result.add(new FontName(aFontArray[0], aFontArray[1]));
        }
        return result;
    }

    class FontName {
        String cssName;
        String fileName;

        FontName(String cssName, String fileName) {
            this.cssName = cssName;
            this.fileName = fileName;
        }

        String getCssName() {
            return this.cssName;
        }

        String getFileName() {
            return this.fileName;
        }
    }
}

