/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.service;

import hu.metainf.plugin.confluence.contentexporter.dao.FontRepository;
import hu.metainf.plugin.confluence.contentexporter.exporter.OperationResult;
import hu.metainf.plugin.confluence.contentexporter.model.Font;
import hu.metainf.plugin.confluence.contentexporter.model.FontFile;
import hu.metainf.plugin.confluence.contentexporter.service.FontService;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public class FontServiceImpl
implements FontService {
    private static final Set<String> validExtensions = new HashSet<String>(){
        {
            this.add("TTF");
            this.add("OTF");
        }
    };
    private final FontRepository fontRepository;

    public FontServiceImpl(FontRepository fontRepository) {
        this.fontRepository = fontRepository;
    }

    @Override
    public OperationResult save(Font newFont) {
        OperationResult<Font> result = new OperationResult<Font>();
        String fontName = newFont.getName();
        if (StringUtils.isEmpty((CharSequence)fontName)) {
            result.addError("name", "hu.metainf.plugin.confluence.contentexporter.mandatory", Collections.singletonList("name"));
        }
        if (newFont.getFiles().isEmpty()) {
            result.addError("font", "hu.metainf.plugin.confluence.contentexporter.least-one-file");
        } else {
            for (FontFile file : newFont.getFiles()) {
                String fileName = file.getFileName();
                String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
                if (this.isValidExtension(extension)) continue;
                List<Object> strings = Arrays.asList(extension, validExtensions.toString());
                result.addError("font", "hu.metainf.plugin.confluence.contentexporter.invalid-extension", strings);
            }
        }
        if (result.isSuccess()) {
            StringBuilder fileNames = new StringBuilder();
            Iterator<FontFile> fileIterator = newFont.getFiles().iterator();
            while (fileIterator.hasNext()) {
                FontFile file = fileIterator.next();
                file.setHash(DigestUtils.sha256Hex((byte[])file.getFontData()));
                fileNames.append(file.getFileName());
                if (!fileIterator.hasNext()) continue;
                fileNames.append(", ");
            }
            newFont.setFileNames(fileNames.toString());
            Font savedFont = this.fontRepository.save(newFont);
            result.setData(savedFont);
        }
        return result;
    }

    private boolean isValidExtension(String extension) {
        for (String validExtension : validExtensions) {
            if (!validExtension.equalsIgnoreCase(extension)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void delete(Long id) {
        this.fontRepository.delete(id);
    }

    @Override
    public List<Font> loadAll() {
        return this.fontRepository.findAll();
    }
}

