/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.css;

import hu.metainf.plugin.confluence.contentexporter.dao.ExportProfileRepository;
import hu.metainf.plugin.confluence.contentexporter.exporter.ExportContext;
import hu.metainf.plugin.confluence.contentexporter.exporter.ResourceLoader;
import hu.metainf.plugin.confluence.contentexporter.exporter.VelocityTemplate;
import hu.metainf.plugin.confluence.contentexporter.exporter.css.CssProcessor;
import hu.metainf.plugin.confluence.contentexporter.exporter.css.PageSizeCssProcessor;
import hu.metainf.plugin.confluence.contentexporter.exporter.io.BufferedFileWriter;
import hu.metainf.plugin.confluence.contentexporter.model.ExportParameters;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CssBuilder {
    private final ExportParameters exportParameters;
    private final ResourceLoader resourceLoader;
    private final List<String> cssFiles;
    private final Map<String, CssProcessor> processorMap;

    public CssBuilder(ExportParameters exportParameters, ExportContext exportContext, ExportProfileRepository profileRepository) {
        this.exportParameters = exportParameters;
        this.resourceLoader = exportContext.getResourceLoader();
        this.cssFiles = new ArrayList<String>();
        this.cssFiles.add("reset.css");
        this.cssFiles.add("page.vm");
        this.cssFiles.add("layout-confluence.css");
        this.cssFiles.add("icon-common.css");
        this.cssFiles.add("image.css");
        this.cssFiles.add("table.css");
        this.cssFiles.add("aui.css");
        this.cssFiles.add("macro-information.css");
        this.cssFiles.add("macro-jira-issue.css");
        this.cssFiles.add("macro-section.css");
        this.cssFiles.addAll(exportParameters.getOutputFormat().getCssFiles());
        this.processorMap = new HashMap<String, CssProcessor>();
        this.processorMap.put("page.vm", new PageSizeCssProcessor(profileRepository));
        this.processorMap.putAll(exportParameters.getOutputFormat().getCssProcessors(exportContext));
    }

    public void buildCss(File combinedCssFile) throws IOException {
        try (BufferedFileWriter cssWriter = new BufferedFileWriter(combinedCssFile);){
            for (String cssFile : this.cssFiles) {
                CssProcessor cssProcessor = this.processorMap.get(cssFile);
                if (cssProcessor != null) {
                    VelocityTemplate cssTemplate = this.resourceLoader.resolveTemplate("css/" + cssFile);
                    cssProcessor.customizeCss(cssTemplate, this.exportParameters);
                    cssWriter.println(cssTemplate.merge());
                    continue;
                }
                cssWriter.println(this.resourceLoader.resolveCss(cssFile));
            }
        }
    }
}

