/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter;

import hu.metainf.logger.api.Logger;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class TempDirectoryCleaner {
    private static final Logger logger = Logger.getLogger(TempDirectoryCleaner.class);
    public static final long MAX_WORKING_DIRECTORY_LIFETIME = 86400000L;
    public static final long MAX_FONT_FILE_LIFETIME = 604800000L;

    public void removeOldWorkDirectories(File tempDirectory) {
        long expiredAt = System.currentTimeMillis() - 86400000L;
        if (null == tempDirectory || !tempDirectory.exists() || !tempDirectory.isDirectory()) {
            return;
        }
        String[] directories = tempDirectory.list((current, name) -> {
            if (!name.startsWith("exp_")) {
                return false;
            }
            File f = new File(current, name);
            return f.isDirectory() && f.lastModified() < expiredAt;
        });
        if (directories != null) {
            for (String directory : directories) {
                try {
                    FileUtils.deleteDirectory((File)new File(tempDirectory, directory));
                }
                catch (IOException e) {
                    logger.error("Can't delete working directory: " + directory, (Throwable)e);
                }
            }
        }
    }

    public void removeOldFonts(File tempDirectory) {
        if (null == tempDirectory || !tempDirectory.exists() || !tempDirectory.isDirectory()) {
            return;
        }
        long expiredAt = System.currentTimeMillis() - 604800000L;
        String[] fontFiles = tempDirectory.list((current, name) -> {
            if (!name.endsWith(".ttf") && !name.endsWith(".otf")) {
                return false;
            }
            File f = new File(current, name);
            return !f.isDirectory() && f.lastModified() < expiredAt;
        });
        if (fontFiles != null) {
            for (String directory : fontFiles) {
                FileUtils.deleteQuietly((File)new File(tempDirectory, directory));
            }
        }
    }
}

