/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ErrorCollection {
    private final Map<String, String> errorMessages = new HashMap<String, String>();
    private final Map<String, String> errorDetails = new HashMap<String, String>();
    private final Map<String, List<Object>> errorArguments = new HashMap<String, List<Object>>();
    private final Map<String, List<Object>> detailsArguments = new HashMap<String, List<Object>>();

    public void addErrorMessage(String key, String errorMessage) {
        this.errorMessages.put(key, errorMessage);
    }

    public void addErrorMessage(String key, String errorMessage, List<Object> arguments) {
        this.errorMessages.put(key, errorMessage);
        this.errorArguments.put(key, arguments);
    }

    public void addGlobalErrorMessage(String errorMessage) {
        this.errorMessages.put(null, errorMessage);
    }

    public void addGlobalErrorMessage(String errorMessage, List<Object> arguments) {
        this.errorMessages.put(null, errorMessage);
        this.errorArguments.put(null, arguments);
    }

    public Map<String, String> getErrorMessages() {
        return this.errorMessages;
    }

    public boolean hasAnyErrorMessages() {
        return !this.errorMessages.isEmpty();
    }

    public String getGlobalErrorMessage() {
        return this.errorMessages.get(null);
    }

    public String getErrorMessage(String key) {
        return this.errorMessages.get(key);
    }

    public Map<String, List<Object>> getErrorArguments() {
        return this.errorArguments;
    }

    public List<Object> getErrorArguments(String key) {
        List<Object> arguments = this.errorArguments.containsKey(key) ? this.errorArguments.get(key) : Collections.emptyList();
        return arguments;
    }

    public List<Object> getGlobalErrorArguments() {
        return this.errorArguments.get(null);
    }

    public void addGlobalErrorDetails(String details, List<Object> arguments) {
        this.errorDetails.put(null, details);
        this.detailsArguments.put(null, arguments);
    }

    public String getGlobalErrorDetails() {
        return this.errorDetails.get(null);
    }

    public List<Object> getGlobalErrorDetailsArguments() {
        return this.detailsArguments.get(null);
    }

    public void addGlobalErrorDetails(String details) {
        this.errorDetails.put(null, details);
    }
}

