/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor;

import hu.metainf.plugin.confluence.contentexporter.exporter.ExportContext;
import hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor.PageProcessor;
import hu.metainf.plugin.confluence.contentexporter.model.ConfluenceContent;
import hu.metainf.plugin.confluence.contentexporter.model.Statistics;
import java.util.List;
import org.htmlcleaner.CommentNode;
import org.htmlcleaner.HtmlNode;
import org.htmlcleaner.TagNode;

public class StyleExtractorProcessor
extends PageProcessor {
    private static final String INLINE_STYLE_PREFIX = "inline_style_";
    private long inlineStyleId = 1L;

    @Override
    public void process(ConfluenceContent page, TagNode rootNode, TagNode viewNode, ExportContext exportContext, Statistics statistics) {
        List styleNodes = rootNode.getElementListByName("style", true);
        for (TagNode styleNode : styleNodes) {
            long newId;
            ++this.inlineStyleId;
            String newPlaceholder = INLINE_STYLE_PREFIX + newId;
            String css = styleNode.getText().toString();
            exportContext.addStyle(newPlaceholder, css);
            styleNode.getParent().insertChildBefore((HtmlNode)styleNode, (HtmlNode)new CommentNode(newPlaceholder));
            styleNode.removeFromTree();
        }
    }
}

