/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor;

import hu.metainf.logger.api.Logger;
import hu.metainf.plugin.confluence.contentexporter.exporter.Bookmarks;
import hu.metainf.plugin.confluence.contentexporter.exporter.ExportContext;
import hu.metainf.plugin.confluence.contentexporter.exporter.io.HttpUtil;
import hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor.PageProcessor;
import hu.metainf.plugin.confluence.contentexporter.model.ConfluenceContent;
import hu.metainf.plugin.confluence.contentexporter.model.OutputFormat;
import hu.metainf.plugin.confluence.contentexporter.model.Statistics;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.htmlcleaner.HtmlNode;
import org.htmlcleaner.TagNode;

public class LinkProcessor
extends PageProcessor {
    private static Logger logger = Logger.getLogger(LinkProcessor.class);
    private OutputFormat outputFormat;

    public LinkProcessor(OutputFormat outputFormat) {
        this.outputFormat = outputFormat;
    }

    @Override
    public void process(ConfluenceContent page, TagNode rootNode, TagNode viewNode, ExportContext exportContext, Statistics statistics) {
        Bookmarks bookmarks = exportContext.getBookmarks();
        List linkNodes = rootNode.getElementListByName("a", true);
        String baseUrl = exportContext.getBaseUrl();
        String absoluteUrlPrefix = HttpUtil.extractDomainAndProtocol(baseUrl);
        this.updateLinks(page, bookmarks, absoluteUrlPrefix, linkNodes);
        HashMap<String, String> internalLinkTooltipMap = new HashMap<String, String>();
        this.updateIdsWithBookmarks(rootNode, internalLinkTooltipMap, bookmarks);
        this.setTooltip(internalLinkTooltipMap, linkNodes);
    }

    private void updateLinks(ConfluenceContent page, Bookmarks bookmarks, String absoluteUrlPrefix, List<? extends TagNode> linkNodes) {
        for (TagNode tagNode : linkNodes) {
            this.addLinkWithImageHack(tagNode);
            String hrefAttribute = tagNode.getAttributeByName("href");
            if (hrefAttribute == null) continue;
            String hrefUrl = hrefAttribute.replaceFirst(absoluteUrlPrefix, "");
            logger.debug("Absolute URL: {} -> {}", new Object[]{hrefAttribute, hrefUrl});
            if (hrefUrl.startsWith("#")) {
                String url = page.getUrl() + hrefUrl;
                String bookmark = bookmarks.getBookmarkByUrl(url);
                if (bookmark == null) {
                    bookmark = bookmarks.generateNextBookmark();
                }
                logger.debug("Replace link href: {} -> {}", new Object[]{hrefUrl, bookmark});
                tagNode.addAttribute("href", "#" + bookmark);
                continue;
            }
            if (HttpUtil.isAbsoluteUrl(hrefUrl)) continue;
            String bookmark = bookmarks.getBookmarkByUrl(hrefUrl);
            if (bookmark != null) {
                this.updateLinkWithBookmark(tagNode, bookmarks, bookmark);
                logger.debug("Relative URL to other page href: {} -> {}", new Object[]{hrefUrl, bookmark});
                continue;
            }
            logger.debug("Relative URL to non-exported page: {}", new Object[]{hrefUrl});
            String href = absoluteUrlPrefix + (hrefUrl.startsWith("/") ? hrefUrl : "/" + hrefUrl);
            tagNode.addAttribute("href", href);
            tagNode.addAttribute("title", href);
        }
    }

    private void updateLinkWithBookmark(TagNode linkNode, Bookmarks bookmarks, String bookmark) {
        String tooltip = bookmarks.getPageTitleByBookmark(bookmark);
        linkNode.addAttribute("href", this.outputFormat.getLinkPrefix(bookmarks.getPageIdByBookmark(bookmark)) + "#" + bookmark);
        linkNode.addAttribute("title", tooltip);
    }

    private void updateIdsWithBookmarks(TagNode rootNode, Map<String, String> internalLinkTooltipMap, Bookmarks bookmarks) {
        for (Map.Entry<String, Map<Long, String>> pageIdBookmarkMap : bookmarks.getUrlBookmarkMap().entrySet()) {
            String url = pageIdBookmarkMap.getKey();
            for (Map.Entry<Long, String> entry : pageIdBookmarkMap.getValue().entrySet()) {
                String targetId;
                TagNode target;
                if (!url.contains("#") || (target = rootNode.findElementByAttValue("id", targetId = url.substring(url.indexOf("#") + 1), true, true)) == null) continue;
                String bookmark = entry.getValue();
                target.addAttribute("id", bookmark);
                String tooltip = target.getText().toString();
                internalLinkTooltipMap.put(bookmark, tooltip);
                this.addNamedAnchorHack(target, bookmark);
            }
        }
    }

    private void setTooltip(Map<String, String> internalLinkTooltipMap, List<? extends TagNode> linkNodes) {
        for (TagNode tagNode : linkNodes) {
            String bookmark;
            String tooltip;
            String href = tagNode.getAttributeByName("href");
            if (href == null || !href.startsWith("#") || (tooltip = internalLinkTooltipMap.get(bookmark = href.substring(1))) == null) continue;
            tagNode.addAttribute("title", tooltip);
        }
    }

    private void addLinkWithImageHack(TagNode linkNode) {
        TagNode childNode;
        List linkChilds = linkNode.getAllChildren();
        if (linkChilds.size() == 1 && linkChilds.get(0) instanceof TagNode && "img".equals((childNode = (TagNode)linkChilds.get(0)).getName())) {
            linkNode.insertChild(0, (HtmlNode)new TagNode("span"));
        }
    }

    private void addNamedAnchorHack(TagNode linkedNode, String bookmark) {
        TagNode namedAnchorNode = new TagNode("a");
        namedAnchorNode.addAttribute("name", bookmark);
        linkedNode.getParent().insertChildBefore((HtmlNode)linkedNode, (HtmlNode)namedAnchorNode);
    }
}

