/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor;

import hu.metainf.logger.api.Logger;
import hu.metainf.plugin.confluence.contentexporter.exporter.DateFormatter;
import hu.metainf.plugin.confluence.contentexporter.exporter.ExportContext;
import hu.metainf.plugin.confluence.contentexporter.exporter.HtmlCleanerFactory;
import hu.metainf.plugin.confluence.contentexporter.exporter.MetadataVelocityConverter;
import hu.metainf.plugin.confluence.contentexporter.exporter.ResourceLoader;
import hu.metainf.plugin.confluence.contentexporter.exporter.VelocityTemplate;
import hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor.PageProcessor;
import hu.metainf.plugin.confluence.contentexporter.model.ConfluenceContent;
import hu.metainf.plugin.confluence.contentexporter.model.Metadata;
import hu.metainf.plugin.confluence.contentexporter.model.Statistics;
import hu.metainf.plugin.util.Escaper;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagNode;

public class CustomFieldPageProcessor
extends PageProcessor {
    private static Logger logger = Logger.getLogger(CustomFieldPageProcessor.class);
    private final MetadataVelocityConverter metadataVelocityConverter = new MetadataVelocityConverter();
    private final HtmlCleaner htmlCleaner = HtmlCleanerFactory.getHtmlCleaner();
    private static final Set<String> tagFields = new HashSet<String>(){
        {
            this.add("[PAGE_NO]");
            this.add("[TOTAL_PAGE_NO]");
        }
    };
    private final DateFormatter dateFormatter;
    private final ResourceLoader resourceLoader;
    private final Escaper escaper = new Escaper();

    public CustomFieldPageProcessor(DateFormatter dateFormatter, ResourceLoader resourceLoader) {
        this.dateFormatter = dateFormatter;
        this.resourceLoader = resourceLoader;
    }

    @Override
    public void process(ConfluenceContent page, TagNode rootNode, TagNode viewNode, ExportContext exportContext, Statistics statistics) {
        Metadata metadata = exportContext.getMetadata();
        List metaDatas = rootNode.getElementListByAttValue("class", "export-custom-field", true, true);
        for (TagNode metaData : metaDatas) {
            ContentNode child;
            String variable = metaData.getText().toString();
            String resolvedValue = this.resolveWithTemplate(variable, metadata);
            metaData.removeAllChildren();
            if (this.isTag(variable)) {
                TagNode html = this.htmlCleaner.clean(resolvedValue);
                child = html.findElementByName("span", true);
            } else {
                child = new ContentNode(resolvedValue);
            }
            metaData.addChild((Object)child);
        }
    }

    private boolean isTag(String fieldVariable) {
        return tagFields.contains(fieldVariable);
    }

    private String resolveWithTemplate(String variable, Metadata metadata) {
        String resolvedValue;
        try {
            String templateName = "custom-field.vm";
            VelocityTemplate customFieldTemplate = this.resourceLoader.resolveTemplate(templateName);
            customFieldTemplate.put("meta", metadata);
            customFieldTemplate.put("dateFormatter", this.dateFormatter);
            customFieldTemplate.put("esc", this.escaper);
            customFieldTemplate.put("content", this.metadataVelocityConverter.convert(variable));
            resolvedValue = customFieldTemplate.merge();
        }
        catch (IOException e) {
            resolvedValue = variable;
            logger.error("Could not resolve Custom field: {}", new Object[]{variable, e});
        }
        return resolvedValue;
    }
}

