/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.output;

import hu.metainf.logger.api.Logger;
import hu.metainf.plugin.confluence.contentexporter.ContentExporterException;
import hu.metainf.plugin.confluence.contentexporter.dao.ExportProfileRepository;
import hu.metainf.plugin.confluence.contentexporter.dao.FontRepository;
import hu.metainf.plugin.confluence.contentexporter.exporter.Bookmarks;
import hu.metainf.plugin.confluence.contentexporter.exporter.output.FileBasedOutputWriter;
import hu.metainf.plugin.confluence.contentexporter.exporter.output.PdfFontHandler;
import hu.metainf.plugin.confluence.contentexporter.model.ConfluencePage;
import hu.metainf.plugin.confluence.contentexporter.model.FilePageCount;
import hu.metainf.plugin.confluence.contentexporter.model.Formatting;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xhtmlrenderer.pdf.DefaultPDFCreationListener;
import org.xhtmlrenderer.pdf.ITextRenderer;
import org.xhtmlrenderer.pdf.PDFCreationListener;
import org.xhtmlrenderer.resource.FSEntityResolver;
import org.xml.sax.EntityResolver;

public abstract class AbstractPdfWriter
extends FileBasedOutputWriter {
    public static final Logger logger = Logger.getLogger(AbstractPdfWriter.class);
    private static final String PAGE_BREAK_TEMPLATE = "<br style='page-break-after:always;display:block' class='%s'/>";
    protected final FontRepository fontRepository;
    protected List<FilePageCount> documentsPageCount = new ArrayList<FilePageCount>();

    public AbstractPdfWriter(Formatting formatting, Bookmarks bookmarks, List<? extends ConfluencePage> pages, ExportProfileRepository profileRepository, FontRepository fontRepository) {
        super(formatting, bookmarks, pages, profileRepository);
        this.fontRepository = fontRepository;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected File convertHtmlToPdf(File sourceFile, Formatting formatting, final File outputFile) throws ContentExporterException {
        try (FileOutputStream os = new FileOutputStream(outputFile);){
            ITextRenderer renderer = new ITextRenderer();
            renderer.setListener((PDFCreationListener)new DefaultPDFCreationListener(){

                public void preWrite(ITextRenderer renderer, int pageCount) {
                    logger.debug("Total page count for " + outputFile.getName() + " is " + pageCount);
                    AbstractPdfWriter.this.documentsPageCount.add(new FilePageCount(outputFile.getName(), pageCount, AbstractPdfWriter.this.totalPageCount + 1));
                    if (AbstractPdfWriter.this.isPageCountingActive) {
                        AbstractPdfWriter.this.totalPageCount = AbstractPdfWriter.this.totalPageCount + pageCount;
                    }
                    logger.debug("Total page count after " + outputFile.getName() + " is " + AbstractPdfWriter.this.totalPageCount);
                }
            });
            PdfFontHandler pdfFontHandler = new PdfFontHandler(this.fontRepository, this.exportContext);
            boolean fontsAdded = pdfFontHandler.addFonts(renderer, formatting);
            if (fontsAdded) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(false);
                factory.setValidating(false);
                DocumentBuilder builder = factory.newDocumentBuilder();
                builder.setEntityResolver((EntityResolver)FSEntityResolver.instance());
                Document document = builder.parse(sourceFile);
                File sourceDirectory = sourceFile.getAbsoluteFile().getParentFile();
                renderer.setDocument(document, sourceDirectory.toURI().toURL().toExternalForm());
                renderer.layout();
                renderer.createPDF((OutputStream)os, true, this.totalPageCount + 1);
                File file = outputFile;
                return file;
            }
            throw new ContentExporterException("Can not add font files to the export! Please check the logs.");
        }
        catch (Exception exception) {
            throw new ContentExporterException(exception);
        }
    }

    @Override
    protected String getPageBreakTemplate() {
        return PAGE_BREAK_TEMPLATE;
    }
}

