/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.css;

import hu.metainf.plugin.confluence.contentexporter.dao.ExportProfileRepository;
import hu.metainf.plugin.confluence.contentexporter.exporter.VelocityTemplate;
import hu.metainf.plugin.confluence.contentexporter.exporter.css.CssProcessor;
import hu.metainf.plugin.confluence.contentexporter.model.ExportParameters;
import hu.metainf.plugin.confluence.contentexporter.model.ExportProfile;
import hu.metainf.plugin.confluence.contentexporter.model.Formatting;
import hu.metainf.plugin.confluence.contentexporter.model.Margin;
import hu.metainf.plugin.confluence.contentexporter.model.PageSettings;
import hu.metainf.plugin.confluence.contentexporter.model.PageSize;
import hu.metainf.plugin.confluence.contentexporter.model.Unit;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PageSizeCssProcessor
implements CssProcessor {
    private static final DecimalFormat decimalFormat = new DecimalFormat("#.##");
    private final ExportProfileRepository profileRepository;

    public PageSizeCssProcessor(ExportProfileRepository profileRepository) {
        this.profileRepository = profileRepository;
    }

    @Override
    public void customizeCss(VelocityTemplate css, ExportParameters exportParameters) {
        ExportProfile profile;
        Formatting formatting = exportParameters.getProfileId() != null ? ((profile = (ExportProfile)this.profileRepository.getById(exportParameters.getProfileId())) != null ? profile.getFormatting() : exportParameters.getFormatting()) : exportParameters.getFormatting();
        String size = this.getSize(formatting);
        css.put("size", size);
        List<Map<String, Object>> marginSettings = this.getMarginSettings(formatting);
        css.put("margins", marginSettings);
    }

    List<Map<String, Object>> getMarginSettings(Formatting formatting) {
        ArrayList<Map<String, Object>> marginSettings = new ArrayList<Map<String, Object>>();
        List<Margin> margins1 = formatting.getMargins();
        if (!margins1.isEmpty()) {
            Margin margin = margins1.get(0);
            String unitString = this.toString(formatting.getUnit());
            HashMap<String, String> pageMargin = new HashMap<String, String>();
            pageMargin.put("top", decimalFormat.format(margin.getTop()).replace(",", ".") + unitString);
            pageMargin.put("right", decimalFormat.format(margin.getRight()).replace(",", ".") + unitString);
            pageMargin.put("bottom", decimalFormat.format(margin.getBottom()).replace(",", ".") + unitString);
            pageMargin.put("left", decimalFormat.format(margin.getLeft()).replace(",", ".") + unitString);
            pageMargin.put("pageSelector", margin.getPageSelector().toString());
            marginSettings.add(pageMargin);
        }
        return marginSettings;
    }

    String getSize(Formatting formatting) {
        String size;
        PageSettings pageSettings = formatting.getPageSettings();
        if (PageSize.CUSTOM.equals((Object)pageSettings.getSize())) {
            Unit unit = formatting.getUnit();
            size = decimalFormat.format(pageSettings.getWidth()) + this.toString(unit) + " " + decimalFormat.format(pageSettings.getHeight()) + this.toString(unit);
        } else {
            switch (pageSettings.getSize()) {
                case LETTER: {
                    size = pageSettings.getSize().toString().toLowerCase();
                    break;
                }
                default: {
                    size = pageSettings.getSize().toString();
                }
            }
            size = size + " " + pageSettings.getOrientation().toString().toLowerCase();
        }
        return size;
    }

    private String toString(Unit unit) {
        return unit.toString().toLowerCase();
    }
}

