/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter;

import hu.metainf.logger.api.Logger;
import hu.metainf.plugin.confluence.contentexporter.model.ConfluencePage;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;
import org.htmlcleaner.TagNode;

public class Bookmarks {
    public static final String TABLE_OF_CONTENTS_URL = "http://tableofcontents/";
    public static final String TO_BE_DELETED_BOOKMARK = "tobedeletedbookmarks";
    private Logger logger = Logger.getLogger(Bookmarks.class);
    private static final String BOOKMARK_PREFIX = "Bookmark";
    protected Map<String, Map<Long, String>> urlBookmarkMap = new HashMap<String, Map<Long, String>>();
    protected Map<Long, String> pageIdBookmarkMap = new HashMap<Long, String>();
    protected Map<String, Long> bookmarkPageIdMap = new HashMap<String, Long>();
    protected Map<String, String> bookmarkTitleMap = new HashMap<String, String>();
    protected int bookmarkCounter = 1;

    public void generateBookmarks(ConfluencePage page, TagNode pageNode) {
        this.generateBookmarks(page, pageNode, page.getTargetId());
    }

    private void generateBookmarks(ConfluencePage page, TagNode pageNode, long id) {
        String pageUrl = page.getUrl();
        String bookmark = this.generateNextBookmark();
        this.pageIdBookmarkMap.put(id, bookmark);
        this.addBookmark(bookmark, id, pageUrl, page.getTitle());
        List targets = pageNode.getElementListHavingAttribute("id", true);
        for (TagNode target : targets) {
            bookmark = this.generateNextBookmark();
            String url = pageUrl + "#" + target.getAttributeByName("id");
            this.addBookmark(bookmark, id, url, target.getText().toString());
        }
    }

    private void addBookmark(String bookmark, long pageId, String url, String title) {
        url = this.normalizeUrl(url);
        this.logger.debug("Add {} -> {} in page: {}, title: {}", new Object[]{bookmark, url, pageId, title});
        this.addBookmarkToUrlMap(bookmark, pageId, url);
        this.bookmarkPageIdMap.put(bookmark, pageId);
        this.bookmarkTitleMap.put(bookmark, StringEscapeUtils.unescapeHtml4((String)title));
    }

    private void addBookmarkToUrlMap(String bookmark, long pageId, String url) {
        String oldBookmark;
        if (!this.urlBookmarkMap.containsKey(url)) {
            this.urlBookmarkMap.put(url, new HashMap());
        }
        if (null != (oldBookmark = this.urlBookmarkMap.get(url).put(pageId, bookmark))) {
            this.logger.error("New bookmark ({}) added for the same url ({}) on the same page ({})", new Object[]{bookmark, url, pageId});
        }
    }

    public String getBookmarkByUrlAndPageId(String pageUrl, long pageId) {
        String result = null;
        String normalizedUrl = this.normalizeUrl(pageUrl);
        this.logger.debug("Finding bookmark for {} (original: {}) on page {}", new Object[]{normalizedUrl, pageUrl, pageId});
        if (this.urlBookmarkMap.containsKey(normalizedUrl)) {
            result = this.urlBookmarkMap.get(normalizedUrl).get(pageId);
        }
        return result;
    }

    public String getBookmarkByUrl(String pageUrl) {
        String result = null;
        String normalizedUrl = this.normalizeUrl(pageUrl);
        this.logger.debug("Finding bookmark for {} (original: {})", new Object[]{normalizedUrl, pageUrl});
        if (this.urlBookmarkMap.containsKey(normalizedUrl)) {
            Map<Long, String> pageIdBookmark = this.urlBookmarkMap.get(normalizedUrl);
            if (pageIdBookmark.size() == 1) {
                result = pageIdBookmark.entrySet().iterator().next().getValue();
            } else {
                for (Map.Entry<Long, String> entry : pageIdBookmark.entrySet()) {
                    if (entry.getKey() <= 0L) continue;
                    result = entry.getValue();
                    break;
                }
            }
        }
        return result;
    }

    public long getPageIdByBookmark(String bookmark) {
        return this.bookmarkPageIdMap.get(bookmark);
    }

    public String getBookmarkByPageId(long pageId) {
        return this.pageIdBookmarkMap.get(pageId);
    }

    public String getPageTitleByBookmark(String bookmark) {
        return this.bookmarkTitleMap.get(bookmark);
    }

    public boolean isDeleteAble(String bookmark) {
        return bookmark != null && bookmark.equals(TO_BE_DELETED_BOOKMARK);
    }

    public String generateNextBookmark() {
        String result = BOOKMARK_PREFIX + this.bookmarkCounter;
        ++this.bookmarkCounter;
        return result;
    }

    String normalizeUrl(String url) {
        int p = url.indexOf(35);
        return p >= 0 ? this.unescapeUrl(url.substring(0, p)) + url.substring(p) : this.unescapeUrl(url);
    }

    private String unescapeUrl(String url) {
        try {
            String urlDecoded = URLDecoder.decode(url, StandardCharsets.UTF_8.name());
            return StringEscapeUtils.unescapeHtml4((String)urlDecoded);
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    public Map<String, Map<Long, String>> getUrlBookmarkMap() {
        return this.urlBookmarkMap;
    }

    public Map<String, String> getUrlBookmarksByPageId(long pageId) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, Map<Long, String>> urlEntry : this.urlBookmarkMap.entrySet()) {
            if (urlEntry.getValue() == null) continue;
            for (Map.Entry<Long, String> pageEntry : urlEntry.getValue().entrySet()) {
                if (!pageEntry.getKey().equals(pageId)) continue;
                result.put(urlEntry.getKey(), pageEntry.getValue());
            }
        }
        return result;
    }
}

