/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.dao.standalone;

import com.atlassian.activeobjects.tx.Transactional;
import hu.metainf.plugin.confluence.contentexporter.dao.StylesheetRepository;
import hu.metainf.plugin.confluence.contentexporter.dao.standalone.AbstractRepositoryImpl;
import hu.metainf.plugin.confluence.contentexporter.dao.standalone.StylesheetDao;
import hu.metainf.plugin.confluence.contentexporter.entity.StylesheetEntity;
import hu.metainf.plugin.confluence.contentexporter.model.Stylesheet;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class StylesheetRepositoryImpl
extends AbstractRepositoryImpl<Stylesheet>
implements StylesheetRepository {
    private StylesheetDao stylesheetDao;

    public StylesheetRepositoryImpl(StylesheetDao stylesheetDao) {
        this.stylesheetDao = stylesheetDao;
    }

    @Override
    public Stylesheet getById(long id) {
        return this.toStylesheet((StylesheetEntity)this.stylesheetDao.getById(id));
    }

    @Override
    public List<Stylesheet> findAll() {
        List entities = this.stylesheetDao.findAll();
        ArrayList<Stylesheet> result = new ArrayList<Stylesheet>();
        for (StylesheetEntity entity : entities) {
            result.add(this.toStylesheet(entity));
        }
        return result;
    }

    @Override
    @Transactional
    public Stylesheet doSave(Stylesheet stylesheet) {
        StylesheetEntity entity;
        long id = stylesheet.getId();
        if (id != 0L) {
            entity = (StylesheetEntity)this.stylesheetDao.getById(id);
            entity.setUpdatedDate(new Date());
        } else {
            entity = (StylesheetEntity)this.stylesheetDao.create();
            entity.setCreatedDate(new Date());
        }
        entity.setName(stylesheet.getName());
        entity.setDescription(stylesheet.getDescription());
        entity.setCss(stylesheet.getCss());
        entity.save();
        stylesheet.setId(entity.getID());
        return stylesheet;
    }

    @Override
    @Transactional
    public void delete(Stylesheet entity) {
        this.stylesheetDao.delete(entity.getId());
    }

    private Stylesheet toStylesheet(StylesheetEntity entity) {
        Stylesheet result = null;
        if (entity != null) {
            result = new Stylesheet();
            result.setId(entity.getID());
            result.setName(entity.getName());
            result.setDescription(entity.getDescription());
            result.setCss(entity.getCss());
        }
        return result;
    }

    public void setStylesheetDao(StylesheetDao stylesheetDao) {
        this.stylesheetDao = stylesheetDao;
    }
}

