/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.controllers;

import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.importexport.resource.DownloadResourceManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.trust.TrustedTokenFactory;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.web.context.StaticHttpContext;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import hu.metainf.logger.api.Logger;
import hu.metainf.plugin.confluence.contentexporter.dao.ExportProfileRepository;
import hu.metainf.plugin.confluence.contentexporter.dao.StylesheetRepository;
import hu.metainf.plugin.confluence.contentexporter.exporter.AddonInfo;
import hu.metainf.plugin.confluence.contentexporter.exporter.ContentExporter;
import hu.metainf.plugin.confluence.contentexporter.exporter.ResourceLoader;
import hu.metainf.plugin.confluence.contentexporter.exporter.output.OutputWriterFactory;
import hu.metainf.plugin.confluence.contentexporter.exporter.standalone.BootstrapUtils;
import hu.metainf.plugin.confluence.contentexporter.exporter.standalone.ServerConnector;
import hu.metainf.plugin.confluence.contentexporter.exporter.standalone.StandaloneContentExporter;
import hu.metainf.plugin.confluence.contentexporter.exporter.standalone.StandaloneContentFetcher;
import hu.metainf.plugin.confluence.contentexporter.exporter.standalone.StandaloneImageFetcher;
import hu.metainf.plugin.confluence.contentexporter.exporter.standalone.StandaloneResourceLoader;
import hu.metainf.plugin.confluence.contentexporter.exporter.standalone.imageloader.ConfluenceImageFetcher;
import hu.metainf.plugin.confluence.contentexporter.exporter.standalone.imageloader.InternalHttpImageFetcher;
import hu.metainf.plugin.confluence.contentexporter.model.ExportParameters;
import hu.metainf.plugin.confluence.contentexporter.service.ConfluenceContentService;
import java.io.File;
import java.io.Serializable;

public class ContentExporterFactory
implements Serializable {
    private static final Logger logger = Logger.getLogger(ContentExporterFactory.class);
    private ExportProfileRepository profileRepository;
    private StylesheetRepository stylesheetRepository;
    private OutputWriterFactory outputWriterFactory;
    private ResourceLoader resourceLoader;
    private ConfluenceContentService confluenceContentService;
    private PageManager pageManager;
    private PermissionManager permissionManager;
    private ServerConnector serverConnector;

    public ContentExporterFactory(ExportProfileRepository profileRepository, StylesheetRepository stylesheetRepository, OutputWriterFactory outputWriterFactory, PageManager pageManager, PermissionManager permissionManager, ResourceLoader resourceLoader, ConfluenceContentService confluenceContentService, ServerConnector serverConnector) {
        this.profileRepository = profileRepository;
        this.stylesheetRepository = stylesheetRepository;
        this.outputWriterFactory = outputWriterFactory;
        this.resourceLoader = resourceLoader;
        this.confluenceContentService = confluenceContentService;
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.serverConnector = serverConnector;
    }

    public ContentExporter createContentExporter(ExportParameters exportParameters, Renderer renderer) {
        BootstrapManager bootstrapManager = (BootstrapManager)ContainerManager.getComponent((String)"bootstrapManager", BootstrapManager.class);
        SettingsManager settingsManager = (SettingsManager)ContainerManager.getComponent((String)"settingsManager", SettingsManager.class);
        TrustedTokenFactory trustedTokenFactory = (TrustedTokenFactory)ContainerManager.getComponent((String)"trustedTokenFactory", TrustedTokenFactory.class);
        PluginResourceLocator pluginResourceLocator = (PluginResourceLocator)ContainerManager.getComponent((String)"pluginResourceLocator", PluginResourceLocator.class);
        DownloadResourceManager downloadResourceManager = (DownloadResourceManager)ContainerManager.getComponent((String)"downloadResourceManager", DownloadResourceManager.class);
        PageManager pageManager = (PageManager)ContainerManager.getComponent((String)"pageManager", PageManager.class);
        PermissionManager permissionManager = (PermissionManager)ContainerManager.getComponent((String)"permissionManager", PermissionManager.class);
        PluginAccessor pluginAccessor = (PluginAccessor)ContainerManager.getComponent((String)"pluginAccessor", PluginAccessor.class);
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        String baseUrl = this.getBaseUrl(settingsManager);
        String contextPath = this.getContextPath(bootstrapManager);
        StandaloneContentFetcher standaloneContentFetcher = new StandaloneContentFetcher(pageManager, permissionManager, this.confluenceContentService, renderer, baseUrl, contextPath, (User)user);
        StandaloneImageFetcher standaloneImageFetcher = new StandaloneImageFetcher(baseUrl, new ConfluenceImageFetcher(pluginResourceLocator, downloadResourceManager), new InternalHttpImageFetcher(baseUrl, contextPath, trustedTokenFactory));
        File tempDirectory = BootstrapUtils.getTempDirectory(bootstrapManager);
        StandaloneContentExporter contentExporter = new StandaloneContentExporter(exportParameters, this.profileRepository, this.stylesheetRepository, standaloneContentFetcher, this.outputWriterFactory, new StandaloneResourceLoader(), tempDirectory, new ServerAddonInfo(pluginAccessor), standaloneImageFetcher, settingsManager.getGlobalSettings().getBaseUrl(), this.serverConnector.isPre68());
        logger.debug("Confluence home: {}", new Object[]{bootstrapManager.getLocalHome()});
        logger.debug("Web app context path: {}", new Object[]{bootstrapManager.getWebAppContextPath()});
        logger.debug("HttpContext context path: {}", new Object[]{new StaticHttpContext().getRequest().getContextPath()});
        logger.debug("Base URL: {}", new Object[]{baseUrl});
        return contentExporter;
    }

    private String getBaseUrl(SettingsManager settingsManager) {
        return settingsManager.getGlobalSettings().getBaseUrl();
    }

    private String getContextPath(BootstrapManager bootstrapManager) {
        return bootstrapManager.getWebAppContextPath();
    }

    private static class ServerAddonInfo
    implements AddonInfo {
        private final PluginAccessor pluginAccessor;

        public ServerAddonInfo(PluginAccessor pluginAccessor) {
            this.pluginAccessor = pluginAccessor;
        }

        @Override
        public String getVersion() {
            Plugin plugin = this.pluginAccessor.getPlugin("com.metainf.confluence.plugin.pagetreeexporter.pagetree-word-exporter-plugin");
            return plugin.getPluginInformation().getVersion();
        }
    }
}

