function initEdit()
{
    var mac = CodeMirror.keyMap["default"] == CodeMirror.keyMap.macDefault;
    var ctrl = mac ? "Cmd" : "Ctrl";

    var extraKeys = {
        "F11": function(cm) {
            cm.setOption("fullScreen", !cm.getOption("fullScreen"));
        },
        "Esc": function(cm) {
            if (cm.getOption("fullScreen")) cm.setOption("fullScreen", false);
        }
    };
    extraKeys[ctrl + "-Space"] = "autocomplete";
    extraKeys[ctrl + "-G"] = "findNext";
    extraKeys["F3"] = "findNext";
    extraKeys[ctrl + "Shift-G"] = "findPrev";
    extraKeys["Shift-F3"] = "findPrev";
    extraKeys[ctrl + "-H"] = "replace";

    var codeMirror = CodeMirror.fromTextArea(document.getElementById("css"), {
        lineNumbers: true,
        mode: "text/css",
        gutters: ["CodeMirror-lint-markers"],
        lint: true,
        extraKeys: extraKeys
    });
    codeMirror.setSize("100%", 400);
}
function initAddStylesheetButton(){
    AJS.$("#add-stylesheet-button").click(function(){
        var addStylesheetContainer = AJS.$("#add-stylesheet");
        MIJS.disableControls(addStylesheetContainer.find("button"));
        MIJS.startSpin(addStylesheetContainer);
        location.href = "new-stylesheet.action";
    });
}
function initEditStylesheetButtons(){
    AJS.$(".edit-stylesheet").click(function() {
        var target = AJS.$(this);
        MIJS.startSpin(target.parent());
    });
}
function initSaveButton(){
    if(AJS.Meta.get('render-mode')=="READ_ONLY"){
        AJS.$("#save-stylesheet-button").disable();
    }
    AJS.$("#save-stylesheet-button").click(function(){
        if(AJS.Meta.get('access-mode') != "READ_ONLY"){
            var saveStylesheetContainer = AJS.$("#save-stylesheet");
            MIJS.disableControls(saveStylesheetContainer.find("button"));
            MIJS.startSpin(saveStylesheetContainer);

            var stylesheetForm = AJS.$("#stylesheet-form");
            stylesheetForm.submit();
        }
    });
}
function initDeleteStylesheetButtons() {
    var deleteConfirmationDialogTemplate = AJS.$("#cex-delete-stylesheet-confirmation-dialog-template").remove();
    if(AJS.Meta.get('render-mode')=="READ_ONLY"){
            AJS.$(".delete-stylesheet").disable();
    }
    AJS.$(".delete-stylesheet").click(function(event) {
        if(AJS.Meta.get('access-mode') != "READ_ONLY"){
            event.preventDefault();
            var target = AJS.$(this);
            var spinner = MIJS.startSpin(target.parent());
            var stylesheetId = target.data("stylesheet-id");
            var stylesheetName = target.data("stylesheet-name");

            var $content = deleteConfirmationDialogTemplate.clone();
            $content.find("#stylesheet-name").text(stylesheetName);

            var confirmationDialog = new AJS.Dialog({
                width: 600,
                height: 200,
                id: "cex-confirmation-dialog"
            });
            confirmationDialog.addHeader("Confirmation");
            confirmationDialog.addPanel("", $content);
            confirmationDialog.addButton("OK", function() {
                window.location.href = AJS.contextPath() + "/admin/plugins/contentexporter/delete-stylesheet.action?id=" + stylesheetId;
            });
            confirmationDialog.addCancel("Cancel", function (dialog) {
                confirmationDialog.remove();
            });

            confirmationDialog.show();
            MIJS.stopSpin(spinner);
        }
    });
}
