/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.service;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import hu.metainf.plugin.confluence.contentexporter.exporter.standalone.StandalonePermissionUtil;
import hu.metainf.plugin.confluence.contentexporter.model.ConfluenceContent;
import hu.metainf.plugin.confluence.contentexporter.model.ConfluenceLabel;
import hu.metainf.plugin.confluence.contentexporter.model.ConfluencePage;
import hu.metainf.plugin.confluence.contentexporter.model.filter.LabelFilter;
import hu.metainf.plugin.confluence.contentexporter.service.ExportProfileServiceImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ConfluenceContentService {
    private SpaceManager spaceManager;
    private PermissionManager permissionManager;

    public ConfluenceContentService(SpaceManager spaceManager, PermissionManager permissionManager) {
        this.spaceManager = spaceManager;
        this.permissionManager = permissionManager;
    }

    public ConfluencePage getPageTree(Page root) {
        return this.internalGetPageTree(root);
    }

    private ConfluencePage internalGetPageTree(Page page) {
        ConfluencePage confluencePage = null;
        if (this.hasAccess((AbstractPage)page)) {
            confluencePage = new ConfluencePage(page.getId(), page.getTitle());
            List children = page.getSortedChildren();
            if (children != null && !children.isEmpty()) {
                for (Page child : children) {
                    ConfluencePage childPage = this.internalGetPageTree(child);
                    if (childPage == null) continue;
                    confluencePage.addChild(childPage);
                }
            }
        }
        return confluencePage;
    }

    public List<ConfluenceContent> getFilteredPageList(AbstractPage page, String labels) {
        LabelFilter filter = new LabelFilter(labels);
        ArrayList<ConfluenceContent> visitedPages = new ArrayList<ConfluenceContent>();
        this.getFilteredPageList(page, visitedPages, filter);
        return visitedPages;
    }

    private void getFilteredPageList(AbstractPage page, List<ConfluenceContent> visitedPages, LabelFilter filter) {
        List children;
        ConfluencePage confluencePage = new ConfluencePage(page.getId(), page.getTitle());
        confluencePage.setLabels(this.getPageLabels(page));
        if (this.hasAccess(page) && (filter == null || filter.accept(confluencePage))) {
            ConfluencePage content = new ConfluencePage(page.getId(), page.getTitle());
            visitedPages.add(content);
        }
        if ((children = ((Page)page).getSortedChildren()) != null && !children.isEmpty()) {
            for (Page child : children) {
                this.getFilteredPageList((AbstractPage)child, visitedPages, filter);
            }
        }
    }

    private boolean hasAccess(AbstractPage page) {
        return StandalonePermissionUtil.canUserAccessToPage(this.getRemoteUser(), page, this.permissionManager);
    }

    private Set<ConfluenceLabel> getPageLabels(AbstractPage page) {
        HashSet<ConfluenceLabel> result = new HashSet<ConfluenceLabel>();
        List pageLabels = page.getEntity().getLabels();
        if (pageLabels != null) {
            for (Label pageLabel : pageLabels) {
                result.add(new ConfluenceLabel(pageLabel.getId(), pageLabel.getNamespace().getPrefix(), pageLabel.getName()));
            }
        }
        return result;
    }

    protected User getRemoteUser() {
        return AuthenticatedUserThreadLocal.get();
    }

    public void createSpace(String spaceKey, String spaceName, String description, ExportProfileServiceImpl exportProfileService) {
        this.spaceManager.createSpace(spaceKey, spaceName, description, this.getRemoteUser());
    }

    public boolean isSpaceExists(String spaceKey) {
        return this.spaceManager.getSpace(spaceKey) != null;
    }
}

