/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import hu.metainf.plugin.confluence.contentexporter.exporter.HtmlCleanerFactory;
import hu.metainf.plugin.confluence.contentexporter.model.ConfluenceLabel;
import hu.metainf.plugin.confluence.contentexporter.model.JsonAble;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.Utils;

public abstract class ConfluenceContent
implements JsonAble {
    private long id;
    private String title;
    private String url;
    private Set<ConfluenceLabel> labels;
    private String body;
    private String spaceKey;
    private int pageHierarchicLevel = -1;
    private static final CleanerProperties cleanerProperties = HtmlCleanerFactory.getHtmlCleaner().getProperties();

    public ConfluenceContent(long id) {
        this(id, "");
    }

    public ConfluenceContent(long id, String title) {
        this(id, title, "");
    }

    public ConfluenceContent(long id, String title, String url) {
        this.id = id;
        this.title = title;
        this.url = url;
    }

    public long getId() {
        return this.id;
    }

    public String getEscapedTitle() {
        return Utils.escapeHtml((String)this.getTitle(), (CleanerProperties)cleanerProperties);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Set<ConfluenceLabel> getLabels() {
        return this.labels;
    }

    public void setLabels(Set<ConfluenceLabel> labels) {
        this.labels = labels;
    }

    public void addLabel(long id, String prefix, String name) {
        if (this.labels == null) {
            this.labels = new HashSet<ConfluenceLabel>();
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            this.labels.add(new ConfluenceLabel(id, prefix, name));
        }
    }

    public boolean hasOneOfTheLabels(String[] labelNames) {
        if (labelNames != null) {
            for (String labelName : labelNames) {
                if (!this.hasLabel(labelName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasLabel(String labelName) {
        if (this.labels != null) {
            for (ConfluenceLabel label : this.labels) {
                if (!label.getName().equals(labelName)) continue;
                return true;
            }
        }
        return false;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String toString() {
        return "AbstractContent{id=" + this.id + "}";
    }

    @Override
    public final ObjectNode toJson() {
        ObjectNode json = new ObjectMapper().createObjectNode();
        json.put("id", this.getId());
        json.put("title", this.getTitle());
        json.put("url", this.getUrl());
        this.toJsonObject(json);
        return json;
    }

    protected abstract void toJsonObject(ObjectNode var1);

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public int getPageHierarchicLevel() {
        return this.pageHierarchicLevel;
    }

    public void setPageHierarchicLevel(int pageHierarchicLevel) {
        this.pageHierarchicLevel = pageHierarchicLevel;
    }
}

