/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.standalone.imageloader;

import com.atlassian.confluence.security.trust.TrustedTokenFactory;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.http.httpclient.TrustedTokenAuthenticator;
import hu.metainf.logger.api.Logger;
import hu.metainf.plugin.confluence.contentexporter.exporter.ImageFetcher;
import hu.metainf.plugin.confluence.contentexporter.exporter.io.HttpUtil;
import hu.metainf.plugin.confluence.contentexporter.exporter.standalone.imageloader.TrustedKeyMissingException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;

public class InternalHttpImageFetcher
implements ImageFetcher {
    private static final Logger logger = Logger.getLogger(InternalHttpImageFetcher.class);
    private TrustedTokenAuthenticator trustedTokenAuthenticator;
    private String baseUrl;
    private String contextPath;

    public InternalHttpImageFetcher(String baseUrl, String contextPath) {
        this.baseUrl = baseUrl;
        this.contextPath = contextPath;
    }

    public InternalHttpImageFetcher(String baseUrl, String contextPath, TrustedTokenFactory trustedTokenFactory) {
        this(baseUrl, contextPath);
        this.trustedTokenAuthenticator = new TrustedTokenAuthenticator(trustedTokenFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream createImageInputStream(String uri) {
        HttpMethod method;
        HttpClient client;
        String url;
        String absoluteUrl = this.getAbsoluteUrl(uri);
        try {
            boolean isEncoded;
            String decodedUrl = URLDecoder.decode(absoluteUrl, StandardCharsets.UTF_8.name());
            boolean bl = isEncoded = !absoluteUrl.equals(decodedUrl);
            url = !isEncoded ? HttpUtil.encodeQueryParams(absoluteUrl) : absoluteUrl;
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            logger.error("Invalid url: {}", new Object[]{absoluteUrl, e});
            throw new IllegalArgumentException(e);
        }
        logger.debug("Internal HTTP image fetcher {} -> {}", new Object[]{uri, absoluteUrl});
        try {
            client = new HttpClient();
            method = this.trustedTokenAuthenticator.makeMethod(client, url);
        }
        catch (NullPointerException e) {
            String message = String.format("Can't create trusted method for %s [Internal HTTP]", uri);
            logger.error(message, (Throwable)e);
            throw new TrustedKeyMissingException(message, e);
        }
        try {
            int statusCode;
            if (method.getRequestHeader("X-Seraph-Trusted-App-ID") == null) {
                logger.warn("Can't get trusted token for user {}!", new Object[]{AuthenticatedUserThreadLocal.getUsername()});
            }
            if ((statusCode = client.executeMethod(method)) == 200) {
                byte[] b = method.getResponseBody();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(b);
                return byteArrayInputStream;
            }
            logger.debug("Received HTTP status code: {}", new Object[]{statusCode});
        }
        catch (Exception e) {
            logger.warn("Can't create image input stream for {} [Internal HTTP]: {}", new Object[]{uri, e.getMessage()});
        }
        finally {
            try {
                method.releaseConnection();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    String getAbsoluteUrl(String uri) {
        if (uri.startsWith(this.contextPath)) {
            uri = uri.replace(this.contextPath, "");
        }
        return this.baseUrl + uri;
    }
}

