/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.output;

import hu.metainf.logger.api.Logger;
import hu.metainf.plugin.confluence.contentexporter.ContentExporterException;
import hu.metainf.plugin.confluence.contentexporter.dao.ExportProfileRepository;
import hu.metainf.plugin.confluence.contentexporter.dao.FontRepository;
import hu.metainf.plugin.confluence.contentexporter.exporter.Bookmarks;
import hu.metainf.plugin.confluence.contentexporter.exporter.VelocityTemplate;
import hu.metainf.plugin.confluence.contentexporter.exporter.io.BufferedFileWriter;
import hu.metainf.plugin.confluence.contentexporter.exporter.output.AbstractPdfWriter;
import hu.metainf.plugin.confluence.contentexporter.exporter.output.HtmlTagBuilder;
import hu.metainf.plugin.confluence.contentexporter.model.ConfluencePage;
import hu.metainf.plugin.confluence.contentexporter.model.FilePageCount;
import hu.metainf.plugin.confluence.contentexporter.model.Formatting;
import hu.metainf.plugin.confluence.contentexporter.model.Node;
import hu.metainf.plugin.confluence.contentexporter.model.OutputFormat;
import hu.metainf.plugin.confluence.contentexporter.model.TocMode;
import hu.metainf.plugin.util.PDFHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FileUtils;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.xmpbox.type.BadFieldValueException;
import org.htmlcleaner.TagNode;

public class PdfMergeWriter
extends AbstractPdfWriter {
    private static final Logger logger = Logger.getLogger(PdfMergeWriter.class);
    private static final String TOC_HTML_FILE_NAME = "table-of-contents.html";
    private static final String TOC_PDF_FILE_NAME = "table-of-contents.pdf";
    private String headContent;
    private ConfluencePage frontCoverPage;
    private ConfluencePage backCoverPage;
    private boolean isTableOfContents = false;
    private String headersFooters;
    private boolean isCalculateTOCPageNumbers = false;
    private Map<String, Map<String, Integer>> bookmarksPageNumber = new HashMap<String, Map<String, Integer>>();
    private Integer numberOfPagesBeforeTOC;
    private static final String BOOKMARKS_TAG = "bookmarks";
    private static final String BOOKMARK_TAG = "bookmark";

    public PdfMergeWriter(FontRepository fontRepository, ExportProfileRepository profileRepository, Formatting formatting, Bookmarks bookmarks, List<? extends ConfluencePage> pages) {
        super(formatting, bookmarks, pages, profileRepository, fontRepository);
    }

    private String getHtmlFileName(long contentId) {
        return this.getFileName(contentId, "html");
    }

    private String getPdfFileName(long contentId) {
        return this.getFileName(contentId, "pdf");
    }

    private String getFileName(long contentId, String extension) {
        return "page" + contentId + "." + extension;
    }

    @Override
    public void start(String headContent) throws IOException {
        this.headContent = headContent;
        this.toc = this.getToc(this.formatting.getTocLevel());
    }

    private List<Node> getTocOfFrontCover(int limit) throws ContentExporterException {
        ArrayList<Node> toc = new ArrayList<Node>();
        try {
            toc.add(this.getNode(limit, toc, this.frontCoverPage));
        }
        catch (IOException ioe) {
            throw new ContentExporterException(ioe);
        }
        return toc;
    }

    private List<Node> getTocOfTOC(int limit) {
        ArrayList<Node> toc = new ArrayList<Node>();
        String tocBookmark = this.bookmarks.getBookmarkByUrl("http://tableofcontents/");
        Node tocHeaderNode = new Node(tocBookmark, tocBookmark, 1, 1);
        tocHeaderNode.setPageId(-3L);
        toc.add(tocHeaderNode);
        return toc;
    }

    private List<Node> getTocOfBackCover(int limit) throws ContentExporterException {
        ArrayList<Node> toc = new ArrayList<Node>();
        try {
            toc.add(this.getNode(limit, toc, this.backCoverPage));
        }
        catch (IOException ioe) {
            throw new ContentExporterException(ioe);
        }
        return toc;
    }

    @Override
    public String getBookmarks() throws ContentExporterException {
        return "$bookmarks";
    }

    @Override
    public boolean doWeNeedSecondRound() {
        boolean result = false;
        if (this.formatting != null) {
            result = this.formatting.isTotalPageCountNeeded();
        }
        return result;
    }

    private String getBookmarksForPage(long pageId) throws ContentExporterException {
        String result = pageId == -2L ? this.printBookmarks(this.tocOfFrontCover, pageId) : (pageId == -3L ? this.printBookmarks(this.tocOfTOC, pageId) : (pageId == -4L ? this.printBookmarks(this.tocOfBackCover, pageId) : this.printBookmarks(this.toc, pageId)));
        return result;
    }

    @Override
    protected String getTargetPageNumber(String bookmark) {
        if (this.isCalculateTOCPageNumbers) {
            for (FilePageCount documentPageCount : this.documentsPageCount) {
                if (!this.bookmarksPageNumber.containsKey(documentPageCount.getFileName())) continue;
                for (Map.Entry<String, Integer> bookmarkPageNumber : this.bookmarksPageNumber.get(documentPageCount.getFileName()).entrySet()) {
                    if (!bookmark.equals(bookmarkPageNumber.getKey())) continue;
                    return String.valueOf(documentPageCount.getStartPageNumber() + bookmarkPageNumber.getValue());
                }
            }
        }
        return "XXXX";
    }

    @Override
    public void finish() throws IOException {
    }

    @Override
    public void addPageNumbersStartFromSection() throws IOException {
        logger.debug("Called addPageNumbersStartFromSection when isPageCountingFinished is " + this.isPageCountingFinished);
        if (!this.isPageCountingFinished) {
            this.isPageCountingActive = true;
            logger.debug("isPageCountingActive have been set true.");
        }
    }

    @Override
    public void closePageNumbersStartFromSection() throws IOException {
        logger.debug("Called closePageNumbersStartFromSection.");
        this.isPageCountingFinished = true;
        this.isPageCountingActive = false;
    }

    @Override
    public void addHeadersFooters(String headersFooters) throws IOException {
        this.headersFooters = headersFooters;
    }

    @Override
    public void addPageBreak(String pageClass) throws IOException {
    }

    @Override
    public void addTableOfContents() throws ContentExporterException {
        if (this.isCalculateTOCPageNumbers) {
            this.totalPageCount = this.numberOfPagesBeforeTOC;
        } else {
            this.numberOfPagesBeforeTOC = this.totalPageCount;
        }
        this.isTableOfContents = true;
        this.tocOfTOC = this.getTocOfTOC(this.formatting.getTocLevel());
        File intermediateHtmlContentFile = this.getIntermediateHtmlContentFile(TOC_HTML_FILE_NAME);
        try (BufferedFileWriter intermediateHtmlWriter = new BufferedFileWriter(intermediateHtmlContentFile);){
            intermediateHtmlWriter.println(this.getPageHeadContent(this.headContent, -3L));
            if (null != this.headersFooters) {
                intermediateHtmlWriter.println(this.headersFooters);
            }
            HtmlTagBuilder tagBuilder = HtmlTagBuilder.DIV().classs("page").classs("table-of-contents");
            if (this.formatting.getTocMode() != TocMode.FLAT) {
                tagBuilder.classs("hierarchical");
            }
            intermediateHtmlWriter.println(tagBuilder);
            intermediateHtmlWriter.println(HtmlTagBuilder.tag("h1") + this.escaper.escapeHtml4(this.formatting.getTocTitle()) + HtmlTagBuilder.tagClose("h1"));
            ArrayList<Integer> counter = new ArrayList<Integer>();
            this.printToc(intermediateHtmlWriter, this.toc, counter);
            intermediateHtmlWriter.println(HtmlTagBuilder.DIV_CLOSE);
            intermediateHtmlWriter.println(HtmlTagBuilder.BODY_CLOSE);
            intermediateHtmlWriter.println(HtmlTagBuilder.HTML_CLOSE);
        }
        catch (IOException e) {
            throw new ContentExporterException(e);
        }
        File pdfFile = this.getFileByName(TOC_PDF_FILE_NAME);
        this.convertHtmlToPdf(this.getFileByName(TOC_HTML_FILE_NAME), this.formatting, pdfFile);
    }

    private String getPageHeadContent(String template, long pageId) throws ContentExporterException {
        try {
            return new VelocityTemplate(this.exportContext.getResourceLoader().getVelocityEngine(), template).put(BOOKMARKS_TAG, pageId == -1L ? "" : this.getBookmarksForPage(pageId)).merge();
        }
        catch (IOException e) {
            throw new ContentExporterException(e);
        }
    }

    private String printBookmarks(List<Node> tocNodes, long pageId) {
        StringBuilder bookmarksBuilder = new StringBuilder();
        bookmarksBuilder.append(HtmlTagBuilder.tag(BOOKMARKS_TAG));
        Set<String> printedBookmarks = this.printTocBookmarks(tocNodes, pageId, bookmarksBuilder);
        this.printNonTocBookmarks(printedBookmarks, pageId, bookmarksBuilder);
        bookmarksBuilder.append(HtmlTagBuilder.tagClose(BOOKMARKS_TAG));
        return bookmarksBuilder.toString();
    }

    private void printNonTocBookmarks(Set<String> printedBookmarks, long pageId, StringBuilder bookmarksBuilder) {
        Map<String, String> urlBookmarksOnPage = this.bookmarks.getUrlBookmarksByPageId(pageId);
        bookmarksBuilder.append(urlBookmarksOnPage.values().stream().filter(bookmarkName -> !printedBookmarks.contains(bookmarkName)).map(bookmarkName -> this.printBookmarkTag((String)bookmarkName) + HtmlTagBuilder.tagClose(BOOKMARK_TAG)).collect(Collectors.joining("", this.printBookmarkTag("tobedeletedbookmarks"), String.valueOf(HtmlTagBuilder.tagClose(BOOKMARK_TAG)))));
    }

    private Set<String> printTocBookmarks(List<Node> tocNodes, long pageId, StringBuilder bookmarksBuilder) {
        HashSet<String> result = new HashSet<String>();
        if (null != tocNodes) {
            int prevLevel = 0;
            int firstLevel = 0;
            boolean firstNode = true;
            for (Node tocNode : tocNodes) {
                boolean needThis;
                boolean bl = needThis = null != tocNode.getPageId() && pageId == tocNode.getPageId();
                if (needThis) {
                    if (firstNode) {
                        firstNode = false;
                        firstLevel = tocNode.getLevel();
                    } else if (tocNode.getLevel() <= prevLevel) {
                        this.printClosingTags(bookmarksBuilder, tocNode.getLevel(), prevLevel);
                    }
                    prevLevel = tocNode.getLevel();
                    bookmarksBuilder.append(this.printBookmarkTag(tocNode.getTarget()));
                    result.add(tocNode.getTarget());
                }
                result.addAll(this.printTocBookmarks(tocNode.getHeaders(), pageId, bookmarksBuilder));
            }
            if (!result.isEmpty()) {
                this.printClosingTags(bookmarksBuilder, firstLevel, prevLevel);
            }
        }
        return result;
    }

    private void printClosingTags(StringBuilder bookmarksBuilder, int deepLevel, int shallowLevel) {
        IntStream.rangeClosed(deepLevel, shallowLevel).forEach(level -> bookmarksBuilder.append(HtmlTagBuilder.tagClose(BOOKMARK_TAG)));
    }

    private String printBookmarkTag(String bookmarkName) {
        return HtmlTagBuilder.tag(BOOKMARK_TAG).attribute("name", bookmarkName).href("#" + bookmarkName).toString();
    }

    @Override
    public void addFrontCover(ConfluencePage frontCoverPage, String title, TagNode rootNode) throws ContentExporterException {
        this.frontCoverPage = frontCoverPage;
        this.tocOfFrontCover = this.getTocOfFrontCover(this.formatting.getTocLevel());
        this.addContent(frontCoverPage, title, rootNode, "cover-page", "front-cover");
    }

    @Override
    public void addBackCover(ConfluencePage backCoverPage, String title, TagNode rootNode) throws ContentExporterException {
        this.backCoverPage = backCoverPage;
        this.tocOfBackCover = this.getTocOfBackCover(this.formatting.getTocLevel());
        this.addContent(backCoverPage, title, rootNode, "cover-page", "back-cover");
    }

    @Override
    public void addPage(ConfluencePage content, String title, TagNode rootNode) throws ContentExporterException {
        this.addContent(content, title, rootNode, "page", "wiki-page");
    }

    private void addContent(ConfluencePage content, String title, TagNode rootNode, String ... extraClasses) throws ContentExporterException {
        File htmlFile = this.writeHtmlFile(content, title, rootNode, extraClasses);
        File pdfFile = this.getFileByName(this.getPdfFileName(content.getTargetId()));
        File finalOutputFile = this.convertHtmlToPdf(htmlFile, this.formatting, pdfFile);
        if (content.getTargetId() > 0L) {
            this.addBookmarkPageNumbers(finalOutputFile);
        }
    }

    private void addBookmarkPageNumbers(File pdfFile) throws ContentExporterException {
        try {
            PDDocument document = PDDocument.load((File)pdfFile, (MemoryUsageSetting)MemoryUsageSetting.setupTempFileOnly());
            this.bookmarksPageNumber.put(pdfFile.getName(), PDFHelper.getAllBookmarkedPageNumber(document));
            document.close();
        }
        catch (IOException e) {
            throw new ContentExporterException(e);
        }
    }

    private File getFileByName(String fileName) {
        return new File(this.exportContext.getWorkingDirectory(), fileName);
    }

    private File writeHtmlFile(ConfluencePage content, String title, TagNode rootNode, String ... extraClasses) throws ContentExporterException {
        try {
            File intermediateHtmlContentFile = this.getIntermediateHtmlContentFile(content);
            try (BufferedFileWriter intermediateHtmlWriter = new BufferedFileWriter(intermediateHtmlContentFile);){
                intermediateHtmlWriter.println(this.getPageHeadContent(this.headContent, content.getTargetId()));
                if (null != this.headersFooters) {
                    intermediateHtmlWriter.println(this.headersFooters);
                }
                intermediateHtmlWriter.println(HtmlTagBuilder.DIV().classs(extraClasses));
                TagNode bodyNode = rootNode.findElementByName("body", true);
                this.addCssClassToHeaders(bodyNode, content);
                this.write(intermediateHtmlWriter, title, this.getBody(rootNode));
                intermediateHtmlWriter.println(HtmlTagBuilder.DIV_CLOSE);
                intermediateHtmlWriter.println(HtmlTagBuilder.BODY_CLOSE);
                intermediateHtmlWriter.println(HtmlTagBuilder.HTML_CLOSE);
            }
            return intermediateHtmlContentFile;
        }
        catch (IOException ioe) {
            throw new ContentExporterException(ioe);
        }
    }

    private File getIntermediateHtmlContentFile(String filename) throws ContentExporterException {
        try {
            File intermediateHtmlContentFile = new File(this.exportContext.getWorkingDirectory(), filename);
            if (!intermediateHtmlContentFile.exists() && !intermediateHtmlContentFile.createNewFile()) {
                throw new ContentExporterException("Could not create file " + intermediateHtmlContentFile.getAbsolutePath());
            }
            return intermediateHtmlContentFile;
        }
        catch (IOException ioe) {
            throw new ContentExporterException(ioe);
        }
    }

    private File getIntermediateHtmlContentFile(ConfluencePage content) throws ContentExporterException {
        return this.getIntermediateHtmlContentFile(this.getHtmlFileName(content.getTargetId()));
    }

    @Override
    public File convert(File sourceFile) throws ContentExporterException {
        ArrayList<InputStream> sources = new ArrayList<InputStream>();
        File outputFile = this.createOutputFile(sourceFile, "pdf");
        try {
            if (this.frontCoverPage != null) {
                sources.add(this.createFileInputStream(this.frontCoverPage));
            }
            if (this.isTableOfContents) {
                this.isCalculateTOCPageNumbers = true;
                this.addTableOfContents();
                sources.add(this.createFileInputStream(TOC_PDF_FILE_NAME));
            }
            for (ConfluencePage page : this.pages) {
                sources.add(this.createFileInputStream(page));
            }
            if (this.backCoverPage != null) {
                sources.add(this.createFileInputStream(this.backCoverPage));
            }
            InputStream mergedIS = this.merge(sources);
            FileUtils.copyInputStreamToFile((InputStream)mergedIS, (File)outputFile);
            this.updateLinkAndBookmarks(outputFile);
        }
        catch (IOException e) {
            throw new ContentExporterException(e);
        }
        return outputFile;
    }

    private void updateLinkAndBookmarks(File pdfFile) throws ContentExporterException {
        try {
            PDDocument document = PDDocument.load((File)pdfFile, (MemoryUsageSetting)MemoryUsageSetting.setupTempFileOnly());
            PDFHelper.updateInnerDocumentLinks(document, OutputFormat.PDF_MERGE.getLinkPrefix(-1L));
            PDFHelper.deleteUnneededBookmarks(document, this.bookmarks::isDeleteAble);
            PDFHelper.updateBookmarks(document, this.bookmarks::getPageTitleByBookmark);
            document.save(pdfFile);
            document.close();
        }
        catch (IOException e) {
            throw new ContentExporterException(e);
        }
    }

    private FileInputStream createFileInputStream(ConfluencePage content) throws IOException {
        return this.createFileInputStream(this.getPdfFileName(content.getTargetId()));
    }

    private FileInputStream createFileInputStream(String filename) throws IOException {
        return new FileInputStream(this.getFileByName(filename));
    }

    /*
     * Exception decompiling
     */
    private InputStream merge(List<InputStream> sources) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PDFMergerUtility createPDFMergerUtility(List<InputStream> sources, ByteArrayOutputStream mergedPDFOutputStream) {
        logger.info("Initialising PDF merge utility");
        PDFMergerUtility pdfMerger = new PDFMergerUtility();
        pdfMerger.addSources(sources);
        pdfMerger.setDestinationStream((OutputStream)mergedPDFOutputStream);
        return pdfMerger;
    }

    private PDDocumentInformation createPDFDocumentInfo(String title, String creator, String subject) {
        logger.info("Setting document info (title, author, subject) for merged PDF");
        PDDocumentInformation documentInformation = new PDDocumentInformation();
        documentInformation.setTitle(title);
        documentInformation.setCreator(creator);
        documentInformation.setSubject(subject);
        return documentInformation;
    }

    /*
     * Exception decompiling
     */
    private PDMetadata createXMPMetadata(COSStream cosStream, String title, String creator, String subject) throws BadFieldValueException, TransformerException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

