/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.css;

import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.LocatorImpl;
import com.steadystate.css.parser.SACParserCSS2;
import hu.metainf.plugin.confluence.contentexporter.css.ValidationErrorHandler;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Locator;
import org.w3c.css.sac.Parser;

public class CssValidator {
    private final CSSOMParser parser = new CSSOMParser((Parser)new SACParserCSS2());
    private final ValidationErrorHandler errorHandler = new ValidationErrorHandler();

    public CssValidator() {
        this.parser.setErrorHandler((ErrorHandler)this.errorHandler);
    }

    public boolean validate(String css) {
        InputSource source = new InputSource((Reader)new StringReader(css));
        try {
            this.parser.parseStyleSheet(source, null, null);
        }
        catch (IOException e) {
            this.errorHandler.fatalError(new CSSParseException(e.getMessage(), (Locator)new LocatorImpl(source.getURI(), 0, 0), (Exception)e));
        }
        return this.errorHandler.isValid();
    }

    public List<Exception> getErrors() {
        return Stream.concat(this.errorHandler.getErrors().stream(), this.errorHandler.getFatalErrors().stream()).collect(Collectors.toList());
    }
}

