/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import hu.metainf.plugin.confluence.contentexporter.model.ConfluenceContent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ConfluencePage
extends ConfluenceContent {
    public static final long UNKNOWN_PAGE_ID = -1L;
    public static final long FRONT_COVER_PAGE_ID = -2L;
    public static final long TABLE_OF_CONTENTS_PAGE_ID = -3L;
    public static final long BACK_COVER_PAGE_ID = -4L;
    private List<ConfluencePage> children = new ArrayList<ConfluencePage>();
    private List<Long> parentHierarchy = new ArrayList<Long>();
    private long httpResponseSize;
    private Integer position;
    private Long targetId;
    private Long parentId;
    private Long closestParentId;
    private String lastModifierUsername;
    private int version;
    private String creatorFullName;
    private String creatorUsername;
    private String lastModifierFullName;
    private Date createdDate;
    private Date lastModifiedDate;

    public ConfluencePage(long pageId) {
        super(pageId);
    }

    public ConfluencePage(long pageId, String title) {
        super(pageId, title);
    }

    public ConfluencePage(long pageId, String title, String url) {
        super(pageId, title, url);
    }

    public void addChild(ConfluencePage descendant) {
        this.children.add(descendant);
    }

    public List<ConfluencePage> getChildren() {
        return this.children;
    }

    public List<Long> getParentHierarchy() {
        return this.parentHierarchy;
    }

    public void setParentHierarchy(List<Long> parentHierarchy) {
        this.parentHierarchy = parentHierarchy;
    }

    public String getCreatorFullName() {
        return this.creatorFullName;
    }

    public void setCreatorFullName(String creatorFullName) {
        this.creatorFullName = creatorFullName;
    }

    public String getLastModifierFullName() {
        return this.lastModifierFullName;
    }

    public void setLastModifierFullName(String lastModifierFullName) {
        this.lastModifierFullName = lastModifierFullName;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public Integer getPosition() {
        return this.position;
    }

    public void setPosition(Integer position) {
        this.position = position;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Long getClosestParentId() {
        return this.closestParentId;
    }

    public void setClosestParentId(Long closestParentId) {
        this.closestParentId = closestParentId;
    }

    public long getHttpResponseSize() {
        return this.httpResponseSize;
    }

    public void setHttpResponseSize(long httpResponseSize) {
        this.httpResponseSize = httpResponseSize;
    }

    @Override
    public String toString() {
        return "Page{id=" + this.getId() + "}";
    }

    @Override
    protected void toJsonObject(ObjectNode json) {
        if (this.getChildren() != null && !this.getChildren().isEmpty()) {
            ArrayNode children = json.arrayNode();
            for (ConfluencePage child : this.getChildren()) {
                ObjectNode jsonChild = child.toJson();
                children.add((JsonNode)jsonChild);
            }
            json.put("children", (JsonNode)children);
        }
    }

    public String getCreatorUsername() {
        return this.creatorUsername;
    }

    public void setCreatorUsername(String creatorUsername) {
        this.creatorUsername = creatorUsername;
    }

    public String getLastModifierUsername() {
        return this.lastModifierUsername;
    }

    public void setLastModifierUsername(String lastModifierUsername) {
        this.lastModifierUsername = lastModifierUsername;
    }

    public void setChildren(List<ConfluencePage> newChildren) {
        this.children.clear();
        this.children.addAll(newChildren);
    }

    public long getTargetId() {
        return this.targetId == null ? this.getId() : this.targetId.longValue();
    }

    public ConfluencePage setTargetId(Long targetId) {
        this.targetId = targetId;
        return this;
    }
}

