/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor;

import hu.metainf.plugin.confluence.contentexporter.exporter.ExportContext;
import hu.metainf.plugin.confluence.contentexporter.exporter.ImageFetcher;
import hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor.ImageDimension;
import hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor.ImageProcessor;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.htmlcleaner.TagNode;

public class PdfImageProcessor
extends ImageProcessor {
    private static final int PIXELS_PER_INCH = 96;
    private static final double LETTER_SIZE_WIDTH_INCHES = 8.5;
    public static final String ATT_WIDTH = "width";
    public static final String ATT_HEIGHT = "height";

    public PdfImageProcessor(ImageFetcher imageFetcher) {
        super(imageFetcher);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processImage(TagNode imgNode, File imageFile, ExportContext exportContext) {
        int desiredWidth;
        ImageDimension dimension = this.getImageDimension(imageFile);
        if (dimension == null) return;
        int imgWidth = dimension.getWidth();
        int imgHeight = dimension.getHeight();
        double imageAspectRatio = (double)imgWidth / (double)imgHeight;
        if (imgNode.hasAttribute(ATT_WIDTH)) {
            String width = imgNode.getAttributeByName(ATT_WIDTH).trim().toLowerCase().replaceAll("\\s*px", "");
            if (!StringUtils.isNumeric((CharSequence)width)) return;
            desiredWidth = Integer.parseInt(width);
        } else {
            if (!imgNode.hasAttribute(ATT_HEIGHT)) return;
            String height = imgNode.getAttributeByName(ATT_HEIGHT).trim().toLowerCase().replaceAll("\\s*px", "");
            if (!StringUtils.isNumeric((CharSequence)height)) return;
            int heightInPx = Integer.parseInt(height);
            desiredWidth = (int)((double)heightInPx * imageAspectRatio);
        }
        int margin = 2;
        int maxWidth = 624;
        int width = desiredWidth > 624 ? 624 : desiredWidth;
        int height = (int)((double)width / imageAspectRatio);
        imgNode.addAttribute(ATT_WIDTH, Integer.toString(width));
        imgNode.addAttribute(ATT_HEIGHT, Integer.toString(height));
    }
}

