/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor;

import hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor.TablePageProcessor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.htmlcleaner.TagNode;

public class FontResizingTablePageProcessor
extends TablePageProcessor {
    public static final String ATT_STYLE = "style";
    public static final String STYLE_FONT_SIZE = "font-size";
    public static final String STYLE_PADDING = "padding";
    public static final String TAG_TD = "td";
    public static final String TAG_TH = "th";
    public static final String TAG_TR = "tr";
    public static final String UNIT_EM = "em";

    @Override
    protected void processTable(TagNode table) {
        if (table == null) {
            return;
        }
        int numOfColumn = this.detectNumberOfColumnsFromElement(table);
        double colScaleFontSize = 1.0;
        if (numOfColumn > 0) {
            colScaleFontSize = FontRangeHelper.getColumnCountInstance().getFontSize(numOfColumn).doubleValue();
        }
        int noOfTRCharacters = this.detectCrossTableMaxCharacters(table);
        double chaScaleFontSize = 1.0;
        if (numOfColumn >= 5) {
            chaScaleFontSize = FontRangeHelper.getCharacterCountInstance().getFontSize(noOfTRCharacters).doubleValue();
        }
        double finalRatio = Math.min(colScaleFontSize, chaScaleFontSize);
        this.setStyleToElement(table, STYLE_FONT_SIZE, String.valueOf(finalRatio) + UNIT_EM);
        this.adjustTablePadding(table, finalRatio);
    }

    private void adjustTablePadding(TagNode tableElement, double finalRatio) {
        Collection<TagNode> tds = this.findElementsByTagName(tableElement, TAG_TD);
        for (TagNode tdElement : tds) {
            this.setStyleToElement(tdElement, STYLE_PADDING, finalRatio / 2.0 + UNIT_EM);
        }
    }

    private Collection<TagNode> findElementsByTagName(TagNode parentElement, String tagName) {
        List nodeList = parentElement.getElementListByName(tagName, true);
        if (nodeList.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<TagNode> elements = new HashSet<TagNode>(nodeList.size());
        for (TagNode node : nodeList) {
            elements.add(node);
        }
        return elements;
    }

    private void setStyleToElement(TagNode e, String styleName, String styleValue) {
        Object newStyle = "";
        if (e.hasAttribute(ATT_STYLE)) {
            String currentStyle = e.getAttributeByName(ATT_STYLE);
            newStyle = currentStyle + "; ";
        }
        newStyle = (String)newStyle + styleName + ":" + styleValue;
        e.addAttribute(ATT_STYLE, (String)newStyle);
    }

    private int detectNumberOfColumnsFromElement(TagNode tableElement) {
        List<? extends TagNode> trs = FontResizingTablePageProcessor.getRows(tableElement);
        if (trs.isEmpty()) {
            return 0;
        }
        int noOfColumns = 0;
        for (TagNode tagNode : trs) {
            int columnsPerRow = tagNode.getElementListByName(TAG_TD, true).size();
            if (columnsPerRow <= noOfColumns) continue;
            noOfColumns = columnsPerRow;
        }
        return noOfColumns;
    }

    private int detectCrossTableMaxCharacters(TagNode tableElement) {
        List<? extends TagNode> trs = FontResizingTablePageProcessor.getRows(tableElement);
        if (trs.isEmpty()) {
            return 0;
        }
        TagNode firstRow = trs.get(0);
        List columns = firstRow.getElementListByName(TAG_TH, true);
        if (columns.isEmpty()) {
            columns = firstRow.getElementListByName(TAG_TD, true);
        }
        Integer[] largestCellByColumns = this.calculateLargestCellByColumns(trs, columns);
        int countAggregatedLargestCell = 0;
        for (Integer largestCellByColumn : largestCellByColumns) {
            countAggregatedLargestCell += largestCellByColumn.intValue();
        }
        return countAggregatedLargestCell;
    }

    private Integer[] calculateLargestCellByColumns(List<? extends TagNode> rows, List<? extends TagNode> columns) {
        Integer[] largestCellByColumns = new Integer[columns.size()];
        for (int i = 0; i < largestCellByColumns.length; ++i) {
            largestCellByColumns[i] = 0;
        }
        for (TagNode tagNode : rows) {
            List tds = tagNode.getElementListByName(TAG_TD, true);
            if (tds.isEmpty()) {
                tds = tagNode.getElementListByName(TAG_TH, true);
            }
            for (int td = 0; td < columns.size(); ++td) {
                String content;
                if (td < tds.size()) {
                    TagNode tdElement = (TagNode)tds.get(td);
                    content = tdElement.getText().toString();
                } else {
                    content = "";
                }
                if (content.length() <= largestCellByColumns[td]) continue;
                largestCellByColumns[td] = content.length();
            }
        }
        return largestCellByColumns;
    }

    private static List<? extends TagNode> getRows(TagNode tableElement) {
        return tableElement.getElementListByName(TAG_TR, true);
    }

    private static class FontRangeHelper<E extends Number> {
        private Map<Integer[], E> internalRangeMap = new HashMap<Integer[], E>();
        private static FontRangeHelper<Double> columnCountInstance = null;
        private static FontRangeHelper<Double> characterCountInstance = null;

        private static void initialize() {
            FontRangeHelper.getColumnCountInstance();
            FontRangeHelper.getCharacterCountInstance();
        }

        static FontRangeHelper<Double> getColumnCountInstance() {
            if (null == columnCountInstance) {
                columnCountInstance = new FontRangeHelper();
                columnCountInstance.setRange(1, 3, 1.0).setRange(4, 7, 0.9).setRange(8, 12, 0.8).setRange(13, 15, 0.7).setRange(16, 18, 0.6).setRange(19, 22, 0.6).setRange(23, 30, 0.5);
            }
            return columnCountInstance;
        }

        static FontRangeHelper<Double> getCharacterCountInstance() {
            if (null == characterCountInstance) {
                characterCountInstance = new FontRangeHelper();
                characterCountInstance.setRange(1, 600, 1.0).setRange(601, 1000, 0.9).setRange(1001, 2000, 0.8).setRange(2001, 4000, 0.7).setRange(4001, 6000, 0.6).setRange(6001, 9000, 0.5).setRange(9001, 15000, 0.4);
            }
            return characterCountInstance;
        }

        private FontRangeHelper() {
        }

        private FontRangeHelper<E> setRange(int start, int end, E d) {
            Integer[] range = new Integer[]{start, end};
            this.internalRangeMap.put(range, d);
            return this;
        }

        Number getFontSize(int numOfColumn) {
            for (Map.Entry<Integer[], E> entry : this.internalRangeMap.entrySet()) {
                Integer[] range = entry.getKey();
                if (numOfColumn < range[0] || numOfColumn > range[1]) continue;
                return (Number)entry.getValue();
            }
            return 1.0;
        }

        static {
            FontRangeHelper.initialize();
        }
    }
}

