/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.output;

import hu.metainf.plugin.confluence.contentexporter.ContentExporterException;
import hu.metainf.plugin.confluence.contentexporter.dao.ExportProfileRepository;
import hu.metainf.plugin.confluence.contentexporter.exporter.Bookmarks;
import hu.metainf.plugin.confluence.contentexporter.exporter.ExportContext;
import hu.metainf.plugin.confluence.contentexporter.exporter.FragmentUtils;
import hu.metainf.plugin.confluence.contentexporter.exporter.io.BufferedFileWriter;
import hu.metainf.plugin.confluence.contentexporter.exporter.output.AbstractOutputWriter;
import hu.metainf.plugin.confluence.contentexporter.exporter.output.HtmlTagBuilder;
import hu.metainf.plugin.confluence.contentexporter.model.ConfluenceContent;
import hu.metainf.plugin.confluence.contentexporter.model.ConfluencePage;
import hu.metainf.plugin.confluence.contentexporter.model.Formatting;
import hu.metainf.plugin.confluence.contentexporter.model.Node;
import hu.metainf.plugin.confluence.contentexporter.model.TocMode;
import hu.metainf.plugin.util.Escaper;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.htmlcleaner.TagNode;

public abstract class FileBasedOutputWriter
extends AbstractOutputWriter {
    private final ExportProfileRepository profileRepository;
    protected final Bookmarks bookmarks;
    protected final Escaper escaper = new Escaper();
    private BufferedFileWriter intermediateHtmlWriter;
    private File intermediateHtmlContentFile;
    protected List<Node> toc;
    protected List<Node> tocOfFrontCover;
    protected List<Node> tocOfBackCover;
    protected List<Node> tocOfTOC;
    protected final Formatting formatting;
    private FragmentUtils fragmentUtils;
    protected static final long DOES_NOT_MATTER_WHAT_PAGE = -1L;

    public FileBasedOutputWriter(Formatting formatting, Bookmarks bookmarks, List<? extends ConfluencePage> pages, ExportProfileRepository profileRepository) {
        super(pages);
        this.formatting = formatting;
        this.bookmarks = bookmarks;
        this.profileRepository = profileRepository;
    }

    @Override
    public void init(ExportContext exportContext) throws IOException {
        super.init(exportContext);
        File workingDirectory = exportContext.getWorkingDirectory();
        this.fragmentUtils = new FragmentUtils(workingDirectory);
        this.intermediateHtmlContentFile = new File(workingDirectory, "content.html");
        if (!this.intermediateHtmlContentFile.createNewFile()) {
            throw new IOException("Working directory is not writable: " + workingDirectory.getAbsolutePath());
        }
    }

    @Override
    public void addFrontCover(ConfluencePage frontCoverPage, String title, TagNode rootNode) throws ContentExporterException {
        try {
            this.intermediateHtmlWriter.println(HtmlTagBuilder.DIV().classs("cover-page").classs("front-cover"));
            this.addCssClassToHeaders(rootNode, frontCoverPage);
            this.write(this.intermediateHtmlWriter, title, this.getBody(rootNode));
            this.intermediateHtmlWriter.println(HtmlTagBuilder.DIV_CLOSE);
        }
        catch (IOException e) {
            throw new ContentExporterException(e);
        }
    }

    @Override
    public void addTableOfContents() throws ContentExporterException {
        try {
            HtmlTagBuilder tagBuilder = HtmlTagBuilder.DIV().classs("page").classs("table-of-contents");
            if (this.formatting.getTocMode() != TocMode.FLAT) {
                tagBuilder.classs("hierarchical");
            }
            this.intermediateHtmlWriter.println(tagBuilder);
            this.intermediateHtmlWriter.println(HtmlTagBuilder.tag("h1") + this.escaper.escapeHtml4(this.formatting.getTocTitle()) + HtmlTagBuilder.tagClose("h1"));
            ArrayList<Integer> counter = new ArrayList<Integer>();
            this.printToc(this.intermediateHtmlWriter, this.toc, counter);
            this.intermediateHtmlWriter.println(HtmlTagBuilder.DIV_CLOSE);
        }
        catch (IOException e) {
            throw new ContentExporterException(e);
        }
    }

    @Override
    public void addPage(ConfluencePage content, String title, TagNode rootNode) throws ContentExporterException {
        try {
            this.intermediateHtmlWriter.println(HtmlTagBuilder.DIV().classs("page").classs("wiki-page"));
            TagNode bodyNode = rootNode.findElementByName("body", true);
            this.addCssClassToHeaders(bodyNode, content);
            this.write(this.intermediateHtmlWriter, title, this.getBody(rootNode));
            this.intermediateHtmlWriter.println(HtmlTagBuilder.DIV_CLOSE);
        }
        catch (IOException ioe) {
            throw new ContentExporterException(ioe);
        }
    }

    @Override
    public void addBackCover(ConfluencePage backCoverPage, String title, TagNode rootNode) throws ContentExporterException {
        try {
            this.intermediateHtmlWriter.println(HtmlTagBuilder.DIV().classs("cover-page").classs("back-cover"));
            this.addCssClassToHeaders(rootNode, backCoverPage);
            this.write(this.intermediateHtmlWriter, title, this.getBody(rootNode));
            this.intermediateHtmlWriter.println(HtmlTagBuilder.DIV_CLOSE);
        }
        catch (IOException e) {
            throw new ContentExporterException(e);
        }
    }

    @Override
    public void finish() throws IOException {
        this.intermediateHtmlWriter.println(HtmlTagBuilder.BODY_CLOSE);
        this.intermediateHtmlWriter.println(HtmlTagBuilder.HTML_CLOSE);
    }

    @Override
    public void addPageNumbersStartFromSection() throws IOException {
        this.intermediateHtmlWriter.println(HtmlTagBuilder.DIV().classs("cex-page-numbers-section"));
    }

    @Override
    public void closePageNumbersStartFromSection() throws IOException {
        this.intermediateHtmlWriter.println(HtmlTagBuilder.DIV_CLOSE);
    }

    @Override
    public void cleanUp() {
        IOUtils.closeQuietly((Writer)this.intermediateHtmlWriter);
    }

    @Override
    public File getIntermediateFile() {
        return this.intermediateHtmlContentFile;
    }

    @Override
    public void addHeadersFooters(String headersFooters) throws IOException {
        this.intermediateHtmlWriter.println(headersFooters);
    }

    @Override
    public void start(String headContent) throws IOException {
        this.intermediateHtmlWriter = new BufferedFileWriter(this.intermediateHtmlContentFile);
        this.intermediateHtmlWriter.println(headContent);
        this.toc = this.getToc(this.formatting.getTocLevel());
    }

    private int findLevel(ConfluencePage page, List<Node> toc) {
        int result = 0;
        if (page != null && page.getParentId() != null) {
            for (Node node : toc) {
                if (!node.getPageId().equals(page.getParentId())) continue;
                result = node.getLevel() + 1;
                break;
            }
        }
        return result;
    }

    private List<Node> getHeaders(TagNode pageNode, int headerDepthLimit, ConfluencePage page, Bookmarks bookmarks) {
        ArrayList<Node> result = new ArrayList<Node>();
        this.collectHeaders(pageNode, result, headerDepthLimit, page, bookmarks);
        if (!result.isEmpty()) {
            this.normalizeHeaderlevels(result);
        }
        return result;
    }

    private static int compare(int x, int y) {
        return x <= y ? x - y : 1;
    }

    private void normalizeHeaderlevels(List<Node> headerList) {
        int lastLevel = headerList.get(0).getLevel();
        headerList.get(0).setLevel(1);
        for (int i = 1; i < headerList.size(); ++i) {
            Node actualHeader = headerList.get(i);
            int actualLevel = actualHeader.getLevel();
            int previousHeaderLevel = headerList.get(i - 1).getLevel();
            actualHeader.setLevel(Math.max(1, previousHeaderLevel + FileBasedOutputWriter.compare(actualLevel, lastLevel)));
            lastLevel = actualLevel;
        }
    }

    private void collectHeaders(TagNode pageNode, List<Node> result, int headerDepthLimit, ConfluencePage page, Bookmarks bookmarks) {
        if (pageNode.getName().matches("h[1-" + headerDepthLimit + "]") && pageNode.getAttributes().get("id") != null) {
            boolean nonBreakableSpace;
            String text = pageNode.getText().toString();
            boolean bl = nonBreakableSpace = text.length() == 1 && text.charAt(0) == '\u00a0';
            if (!(text.equals("") || text.equals("\u00a0") || text.equals("&nbsp;") || nonBreakableSpace)) {
                int level = Integer.parseInt(pageNode.getName().substring(1));
                String id = pageNode.getAttributeByName("id");
                String url = page.getUrl() + "#" + id;
                Node headerNode = new Node(text, bookmarks.getBookmarkByUrlAndPageId(url, page.getTargetId()), level, level);
                result.add(headerNode);
            }
        }
        for (TagNode childTag : pageNode.getChildTags()) {
            this.collectHeaders(childTag, result, headerDepthLimit, page, bookmarks);
        }
    }

    protected void addCssClassToHeaders(TagNode bodyNode, ConfluenceContent page) {
        List<Node> headers = null;
        for (Node n : this.toc) {
            if (!n.getPageId().equals(page.getId())) continue;
            headers = n.getAllHeaders();
            break;
        }
        if (headers != null && bodyNode != null) {
            List nodeElements = bodyNode.getElementListHavingAttribute("id", true);
            for (TagNode tn : nodeElements) {
                for (Node n : headers) {
                    if (!tn.getAttributeByName("id").equals(n.getTarget())) continue;
                    tn.addAttribute("class", "toc-header-" + n.getLevel());
                }
            }
        }
    }

    protected void printToc(BufferedFileWriter intermediateHtmlWriter, List<Node> tocList, List<Integer> counter) throws IOException {
        boolean isPage = counter.isEmpty();
        counter.add(1);
        intermediateHtmlWriter.println(HtmlTagBuilder.DIV().classs("cex-toc-container cex-toc-container-level-" + counter.size()));
        for (int i = 0; i < tocList.size(); ++i) {
            Node tocNode = tocList.get(i);
            int nextLevel = tocList.size() > i + 1 ? tocList.get(i + 1).getLevel() : tocList.get(0).getLevel();
            HtmlTagBuilder tocDiv = HtmlTagBuilder.DIV().classs("cex-toc-item").classs("cex-toc-item-level-" + counter.size());
            if (isPage) {
                tocDiv.classs("cex-toc-ref-to-page");
            } else {
                tocDiv.classs("cex-toc-ref-to-header").classs("cex-toc-original-header-" + tocNode.getHeaderLevel()).classs("cex-toc-normalized-header-" + tocNode.getLevel());
            }
            tocDiv.id("cex-toc-level-" + this.getTocId(counter));
            intermediateHtmlWriter.println(tocDiv);
            String targetLink = this.getLinkPrefix(-1L) + "#" + tocNode.getTarget();
            if (isPage || !this.formatting.isHeadingNumbering()) {
                intermediateHtmlWriter.println(HtmlTagBuilder.A().classs("cex-toc-counter").href(targetLink) + this.printTocCounter(counter) + " - " + HtmlTagBuilder.A_CLOSE);
            }
            intermediateHtmlWriter.println(HtmlTagBuilder.A().classs("cex-toc-text").href(targetLink) + tocNode.getText() + HtmlTagBuilder.A_CLOSE);
            intermediateHtmlWriter.println(HtmlTagBuilder.A().classs("cex-toc-page-number").href(targetLink) + HtmlTagBuilder.A_CLOSE);
            String targetPageNumber = this.getTargetPageNumber(tocNode.getTarget());
            if (null != targetPageNumber) {
                intermediateHtmlWriter.println(HtmlTagBuilder.A().href(targetLink) + targetPageNumber + HtmlTagBuilder.A_CLOSE);
            }
            intermediateHtmlWriter.println(HtmlTagBuilder.DIV_CLOSE);
            boolean hasPrintedHeaders = false;
            if (tocNode.getHeaders() != null && !tocNode.getHeaders().isEmpty()) {
                this.printToc(intermediateHtmlWriter, tocNode.getHeaders(), counter);
                hasPrintedHeaders = true;
            }
            if (nextLevel > tocNode.getLevel()) {
                intermediateHtmlWriter.println(HtmlTagBuilder.DIV().classs("cex-toc-container").classs("cex-toc-container-level-" + counter.size()));
                if (hasPrintedHeaders) continue;
                counter.add(1);
                continue;
            }
            if (nextLevel == tocNode.getLevel()) {
                if (hasPrintedHeaders) {
                    this.removeLastCounter(counter);
                }
                this.incrementLastCounter(counter);
                continue;
            }
            if (nextLevel >= tocNode.getLevel()) continue;
            if (hasPrintedHeaders) {
                counter.remove(counter.size() - 1);
            }
            for (int j = tocNode.getLevel(); j != nextLevel; --j) {
                intermediateHtmlWriter.println(HtmlTagBuilder.DIV_CLOSE);
                this.removeLastCounter(counter);
            }
            this.incrementLastCounter(counter);
        }
        intermediateHtmlWriter.println(HtmlTagBuilder.DIV_CLOSE);
    }

    protected String getTargetPageNumber(String target) {
        return null;
    }

    private void removeLastCounter(List<Integer> counter) {
        int lastIndex = counter.size() - 1;
        counter.remove(lastIndex);
    }

    private void incrementLastCounter(List<Integer> counter) {
        int lastIndex = counter.size() - 1;
        counter.set(lastIndex, counter.get(lastIndex) + 1);
    }

    private String printTocCounter(List<Integer> counter) {
        StringBuilder result = new StringBuilder();
        for (Integer i : counter) {
            result.append(i.toString()).append(".");
        }
        return result.toString();
    }

    public String getTocId(List<Integer> counter) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < counter.size(); ++i) {
            result.append(counter.get(i).toString());
            if (i == counter.size() - 1) continue;
            result.append("-");
        }
        return result.toString();
    }

    List<Node> getToc(int limit) throws IOException {
        ArrayList<Node> toc = new ArrayList<Node>();
        for (ConfluencePage page : this.pages) {
            toc.add(this.getNode(limit, toc, page));
        }
        return toc;
    }

    protected Node getNode(int limit, List<Node> toc, ConfluencePage page) throws IOException {
        int level = this.findLevel(page, toc);
        page.setPageHierarchicLevel(level);
        Node node = new Node(page.getTitle(), this.bookmarks.getBookmarkByPageId(page.getTargetId()), level, 0);
        node.setPageId(page.getTargetId());
        TagNode tagNode = this.fragmentUtils.getPageNode(page.getId());
        node.setHeaders(this.getHeaders(tagNode, limit, page, this.bookmarks));
        node.setHeadersPageId(page.getTargetId());
        node.setAllHeaders(this.getHeaders(tagNode, 6, page, this.bookmarks));
        return node;
    }

    @Override
    public void addPageBreak(String pageClass) throws IOException {
        this.intermediateHtmlWriter.println(String.format(this.getPageBreakTemplate(), pageClass));
    }

    @Override
    public String getPageTitle(String bookmarkId, String pageTitle, int pageHierarchicalLevel) {
        Object classIdentifier = pageHierarchicalLevel != -1 ? "" + pageHierarchicalLevel : "cover";
        return "<h1 class='page-title-lvl-" + (String)classIdentifier + "' id='" + bookmarkId + "'>" + pageTitle + "</h1>";
    }

    protected abstract String getPageBreakTemplate();
}

