/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter;

import hu.metainf.logger.api.Logger;
import hu.metainf.plugin.confluence.contentexporter.exporter.ContentExporter;
import hu.metainf.plugin.confluence.contentexporter.exporter.HtmlCleanerFactory;
import hu.metainf.plugin.confluence.contentexporter.model.ConfluencePage;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagNode;

public class FragmentUtils {
    private static Logger logger = Logger.getLogger(ContentExporter.class);
    private final HtmlCleaner htmlCleaner = HtmlCleanerFactory.getHtmlCleaner();
    private File workingDirectory;

    public FragmentUtils(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    private File createFragmentFile(long id) {
        return new File(this.workingDirectory, "fragment" + Long.toString(id) + ".html");
    }

    public TagNode getPageNode(long id) throws IOException {
        String content;
        File f = this.createFragmentFile(id);
        try {
            content = FileUtils.readFileToString((File)f, (String)"UTF-8");
        }
        catch (Exception e) {
            logger.error("Can't read fragment: " + f, (Throwable)e);
            throw new IOException(e);
        }
        return this.htmlCleaner.clean(content);
    }

    public void saveFragment(long id, ConfluencePage page) throws IOException {
        File f = this.createFragmentFile(id);
        try {
            FileUtils.writeStringToFile((File)f, (String)page.getBody(), (String)"UTF-8");
        }
        catch (IOException e) {
            logger.error("Can't write fragment: " + f, (Throwable)e);
            throw e;
        }
    }
}

