/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter;

import hu.metainf.logger.api.Logger;
import hu.metainf.plugin.confluence.contentexporter.ContentExporterException;
import hu.metainf.plugin.confluence.contentexporter.dao.ExportProfileRepository;
import hu.metainf.plugin.confluence.contentexporter.dao.StylesheetRepository;
import hu.metainf.plugin.confluence.contentexporter.exporter.AddonInfo;
import hu.metainf.plugin.confluence.contentexporter.exporter.Bookmarks;
import hu.metainf.plugin.confluence.contentexporter.exporter.ContentFetcher;
import hu.metainf.plugin.confluence.contentexporter.exporter.DateFormatter;
import hu.metainf.plugin.confluence.contentexporter.exporter.ExportContext;
import hu.metainf.plugin.confluence.contentexporter.exporter.Fetch;
import hu.metainf.plugin.confluence.contentexporter.exporter.FragmentUtils;
import hu.metainf.plugin.confluence.contentexporter.exporter.HtmlCleanerFactory;
import hu.metainf.plugin.confluence.contentexporter.exporter.ImageFetcher;
import hu.metainf.plugin.confluence.contentexporter.exporter.Images;
import hu.metainf.plugin.confluence.contentexporter.exporter.MetadataVelocityConverter;
import hu.metainf.plugin.confluence.contentexporter.exporter.OperationResult;
import hu.metainf.plugin.confluence.contentexporter.exporter.Progress;
import hu.metainf.plugin.confluence.contentexporter.exporter.ProgressData;
import hu.metainf.plugin.confluence.contentexporter.exporter.ResourceLoader;
import hu.metainf.plugin.confluence.contentexporter.exporter.VelocityTemplate;
import hu.metainf.plugin.confluence.contentexporter.exporter.css.CssBuilder;
import hu.metainf.plugin.confluence.contentexporter.exporter.output.OutputWriter;
import hu.metainf.plugin.confluence.contentexporter.exporter.output.OutputWriterFactory;
import hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor.CustomFieldPageProcessor;
import hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor.FontResizingTablePageProcessor;
import hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor.LinkProcessor;
import hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor.PageProcessor;
import hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor.PageProcessorAction;
import hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor.StyleExtractorProcessor;
import hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor.SvgPageProcessor;
import hu.metainf.plugin.confluence.contentexporter.exporter.pageprocessor.WordBreakingTablePageProcessor;
import hu.metainf.plugin.confluence.contentexporter.exporter.standalone.imageloader.TrustedKeyMissingException;
import hu.metainf.plugin.confluence.contentexporter.model.ConfluenceContent;
import hu.metainf.plugin.confluence.contentexporter.model.ConfluencePage;
import hu.metainf.plugin.confluence.contentexporter.model.ExportParameters;
import hu.metainf.plugin.confluence.contentexporter.model.ExportProfile;
import hu.metainf.plugin.confluence.contentexporter.model.Formatting;
import hu.metainf.plugin.confluence.contentexporter.model.Metadata;
import hu.metainf.plugin.confluence.contentexporter.model.OutputFormat;
import hu.metainf.plugin.confluence.contentexporter.model.PageNumbersAreaFrom;
import hu.metainf.plugin.confluence.contentexporter.model.PageNumbersAreaTo;
import hu.metainf.plugin.confluence.contentexporter.model.Statistics;
import hu.metainf.plugin.confluence.contentexporter.model.Stylesheet;
import hu.metainf.plugin.util.Escaper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;
import org.htmlcleaner.XmlSerializer;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;

public abstract class ContentExporter {
    private static final Logger logger = Logger.getLogger(ContentExporter.class);
    public static final String COMBINED_CSS_FILENAME = "combined.css";
    private static final String OUTPUT_FILENAME_DATE_FORMAT = "yyyyMMdd_HHmmss";
    private static final SecureRandom secureRandom = new SecureRandom();
    private static final CleanerProperties cleanerProperties = HtmlCleanerFactory.getHtmlCleaner().getProperties();
    static final String WORKING_DIRECTORY_PREFIX = "exp_";
    private static int downloadCounter = 0;
    private final HtmlCleaner htmlCleaner = HtmlCleanerFactory.getHtmlCleaner();
    private final DateFormatter dateFormatter = new DateFormatter();
    private final Escaper escaper = new Escaper();
    private final StylesheetRepository stylesheetRepository;
    private final MetadataVelocityConverter metadataVelocityConverter = new MetadataVelocityConverter();
    private final OperationResult status = new OperationResult();
    private final Progress progress = new Progress();
    private final List<ConfluencePage> pageList = new ArrayList<ConfluencePage>();
    protected File tempDirectory = null;
    protected ContentFetcher contentFetcher;
    private final AddonInfo addonInfo;
    protected ImageFetcher imageFetcher;
    protected ResourceLoader resourceLoader;
    protected ExportParameters exportParameters;
    private FragmentUtils fragmentUtils;
    private String exportId;
    private File workingDirectory = null;
    private OutputWriter outputWriter;
    private Date exportTime;
    private String outputFilename;
    private OutputFormat outputFormat;
    protected List<PageProcessor> pageProcessors;
    private Bookmarks bookmarks;
    private Images images;
    private Statistics statistics;
    private final ExportProfileRepository profileRepository;
    private final OutputWriterFactory outputWriterFactory;
    protected String baseUrl;
    private ConfluencePage backCoverPage;
    private ConfluencePage frontCoverPage;
    private static final boolean FIRST_ROUND = true;
    private static final boolean SECOND_ROUND = false;
    private static final String OUTPUT_FILENAME_DISABLED_CHARACTERS_REGEXP = "[\\x00-\\x1F\\\\/|:?\\*\"<>&]";
    private static final String OUTPUT_FILENAME_TEMPLATE = "%s-v%d-%s.%s";

    protected ContentExporter(ExportParameters exportParameters, ExportProfileRepository profileRepository, StylesheetRepository stylesheetRepository, ContentFetcher contentFetcher, OutputWriterFactory outputWriterFactory, ResourceLoader resourceLoader, File tempDirectory, AddonInfo addonInfo, ImageFetcher imageFetcher, String baseUrl) {
        this.exportParameters = exportParameters;
        this.profileRepository = profileRepository;
        this.stylesheetRepository = stylesheetRepository;
        this.contentFetcher = contentFetcher;
        this.outputWriterFactory = outputWriterFactory;
        this.resourceLoader = resourceLoader;
        this.tempDirectory = tempDirectory;
        this.addonInfo = addonInfo;
        this.imageFetcher = imageFetcher;
        this.baseUrl = baseUrl;
        this.exportId = this.createUniqueExportId();
        this.statistics = new Statistics();
        this.init();
    }

    private void init() {
        try {
            this.createTempDirectory();
            this.workingDirectory = this.createWorkingDirectory();
            this.fragmentUtils = new FragmentUtils(this.workingDirectory);
            this.exportTime = new Date();
            this.outputFormat = this.exportParameters.getOutputFormat();
            this.pageProcessors = new ArrayList<PageProcessor>();
            this.bookmarks = new Bookmarks();
            this.images = new Images();
            logger.info("Export {} started in {}", new Object[]{this.exportId, this.workingDirectory.getAbsolutePath()});
        }
        catch (ContentExporterException contentExporterException) {
            // empty catch block
        }
    }

    private void createTempDirectory() throws ContentExporterException {
        logger.debug("Temp directory: {}", new Object[]{this.tempDirectory});
        if (!this.tempDirectory.exists() && !this.tempDirectory.mkdir()) {
            this.status.addGlobalError("Can not create temp directory: " + this.tempDirectory.getAbsolutePath());
            throw new ContentExporterException();
        }
    }

    private File createWorkingDirectory() throws ContentExporterException {
        Path result = null;
        try {
            result = Files.createTempDirectory(Paths.get(this.tempDirectory.toURI()), WORKING_DIRECTORY_PREFIX, new FileAttribute[0]);
        }
        catch (IOException e) {
            this.status.addGlobalError("Could not create working directory: " + e.getMessage());
            throw new ContentExporterException();
        }
        return result.toFile();
    }

    public void extract() {
        if (this.status.isSuccess()) {
            try {
                this.extractContent();
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private void extractContent() throws IOException {
        this.progress.setData(new ProgressData(ProgressData.ProgressPhase.FETCHING_PAGES));
        int totalPageCount = this.exportParameters.getSelectedContentIdList().size();
        for (int pageIndex = 0; pageIndex < totalPageCount; ++pageIndex) {
            long id = this.exportParameters.getSelectedContentIdList().get(pageIndex);
            this.progress.calculateProgressValue(ProgressData.ProgressPhase.GENERATING_PAGES, pageIndex, totalPageCount);
            ConfluencePage page = this.fetchPage(id);
            this.findClosestParent(page);
            this.pageList.add(page);
        }
        Formatting formatting = this.getEffectiveFormatting();
        if (formatting.isFrontCover()) {
            this.frontCoverPage = this.fetchPage(formatting.getFrontCover()).setTargetId(-2L);
        }
        if (formatting.isBackCover()) {
            this.backCoverPage = this.fetchPage(formatting.getBackCover()).setTargetId(-4L);
        }
        if (this.pageList.isEmpty()) {
            throw new IllegalArgumentException("Export content is empty!");
        }
    }

    private ConfluencePage fetchPage(long id) throws IOException {
        ConfluencePage page;
        EnumSet<Fetch> fetchOptions = EnumSet.of(Fetch.BODY_IN_EXPORT_VIEW, Fetch.PARENT_HIERARCHY);
        if (this.pageList.isEmpty()) {
            fetchOptions.add(Fetch.VERSION_INFO);
        }
        if ((page = this.contentFetcher.getPage(id, fetchOptions, this.statistics)) != null) {
            this.fragmentUtils.saveFragment(id, page);
            page.setBody(null);
        } else {
            logger.debug("Can not extract content for page: {}", new Object[]{id});
            page = new ConfluencePage(id);
        }
        return page;
    }

    private void findClosestParent(ConfluencePage page) {
        Long result = null;
        for (Long l : page.getParentHierarchy()) {
            if (!this.exportParameters.getSelectedContentIdList().contains(l)) continue;
            result = l;
            break;
        }
        page.setClosestParentId(result);
    }

    public void export() {
        File contentFile = null;
        if (this.status.isSuccess()) {
            ExportContext exportContext = new ExportContext(this.baseUrl, this.tempDirectory, this.workingDirectory, this.contentFetcher, this.imageFetcher, this.resourceLoader, this.bookmarks, this.images, new Metadata(this.getFirstPage(), this.exportTime, this.outputFormat), this.outputFormat);
            try {
                this.outputWriter = this.outputWriterFactory.getInstance(this.outputFormat, this.contentFetcher, this.getEffectiveFormatting(), this.bookmarks, this.exportParameters.getRootContentId(), this.pageList, this.frontCoverPage, this.backCoverPage);
                this.outputWriter.init(exportContext);
                this.buildCombinedCssFile(exportContext);
                logger.debug("Export content started first round.");
                contentFile = this.exportContent(exportContext, true);
                logger.debug("Export content finished first round.");
                if (this.outputWriter.doWeNeedSecondRound()) {
                    this.outputWriter.resetTotalPageCount();
                    logger.debug("Export content started second round.");
                    contentFile = this.exportContent(exportContext, false);
                    logger.debug("Export content finished second round.");
                }
                try {
                    this.progress.setData(new ProgressData(ProgressData.ProgressPhase.CONVERTING_PAGES));
                    File outputFile = this.outputWriter.convert(contentFile);
                    this.status.setData(outputFile);
                    logger.info("Exported file: {}", new Object[]{outputFile});
                }
                catch (Exception e) {
                    logger.error("Convert of export '{}' failed in directory {}.", new Object[]{this.exportId, this.workingDirectory, e});
                    this.handleException(e);
                }
            }
            catch (TrustedKeyMissingException e) {
                logger.error("Confluence application key missing", (Throwable)e);
                this.status.addGlobalError("hu.metainf.plugin.confluence.contentexporter.error.confluence-key.missing");
                this.status.addGlobalErrorDetails("hu.metainf.plugin.confluence.contentexporter.error.confluence-key.missing.details");
            }
            catch (Exception e) {
                logger.error("Export '{}' failed in directory {}. Export parameters: {}; Export context: {}", new Object[]{this.exportId, this.workingDirectory, ToStringBuilder.reflectionToString((Object)this.exportParameters), ToStringBuilder.reflectionToString((Object)exportContext), e});
                this.handleException(e);
            }
        }
    }

    private void buildCombinedCssFile(ExportContext exportContext) throws IOException {
        CssBuilder cssBuilder = new CssBuilder(this.exportParameters, exportContext, this.profileRepository);
        cssBuilder.buildCss(new File(this.workingDirectory, COMBINED_CSS_FILENAME));
    }

    private void handleException(Exception e) {
        this.status.addGlobalError(e.getMessage());
        this.status.addGlobalErrorDetails(ExceptionUtils.getStackTrace((Throwable)e), Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File exportContent(ExportContext exportContext, boolean firstRound) throws IOException, ContentExporterException {
        this.createPageProcessors();
        if (this.status.isSuccess()) {
            XmlSerializer serializer = HtmlCleanerFactory.getXmlSerializer();
            ConfluencePage firstPage = this.getFirstPage();
            this.initOutputFilename(firstPage);
            Formatting formatting = this.getEffectiveFormatting();
            if (firstRound) {
                this.generateBookmarksForEveryPage();
                if (formatting.isFrontCover() && this.frontCoverPage != null) {
                    this.generateBookmarksForFrontCover();
                }
                if (formatting.isTableOfContents()) {
                    this.generateBookmarkForTableOfContents(formatting);
                }
                if (formatting.isBackCover() && this.backCoverPage != null) {
                    this.generateBookmarksForBackCover();
                }
            }
            try {
                String headTemplate = this.outputFormat.name().toLowerCase() + "/master-header.vm";
                String headContent = this.processTemplateWithMetadata(exportContext.getMetadata(), headTemplate, formatting);
                this.outputWriter.start(headContent);
                String headersFooters = this.processHeadersFooters(exportContext, serializer, firstPage);
                this.outputWriter.addHeadersFooters(headersFooters);
                if (PageNumbersAreaFrom.COVER_PAGE.isStart(formatting)) {
                    this.outputWriter.addPageNumbersStartFromSection();
                }
                if (formatting.isFrontCover() && this.frontCoverPage != null) {
                    TagNode rootNode = this.buildCssAndProcess(this.frontCoverPage, exportContext);
                    String title = this.outputWriter.getPageTitle(this.bookmarks.getBookmarkByPageId(this.frontCoverPage.getTargetId()), this.frontCoverPage.getTitle(), this.frontCoverPage.getPageHierarchicLevel());
                    this.outputWriter.addFrontCover(this.frontCoverPage, title, rootNode);
                    this.outputWriter.addSectionBreak("cover-page front-cover");
                }
                if (PageNumbersAreaFrom.TABLE_OF_CONTENTS.isStart(formatting)) {
                    this.outputWriter.addPageNumbersStartFromSection();
                }
                if (formatting.isTableOfContents() || OutputFormat.HTML.equals((Object)this.outputFormat)) {
                    this.outputWriter.addTableOfContents();
                    this.outputWriter.addSectionBreak("table-of-contents");
                }
                if (PageNumbersAreaFrom.FIRST_EXPORTED_PAGE.isStart(formatting)) {
                    this.outputWriter.addPageNumbersStartFromSection();
                }
                this.progress.setData(new ProgressData(firstRound ? ProgressData.ProgressPhase.GENERATING_PAGES : ProgressData.ProgressPhase.GENERATING_PAGES_WITH_FULL_PAGE_NUMBERS));
                boolean isFirstPage = true;
                int totalPageCount = this.pageList.size();
                for (int pageIndex = 0; pageIndex < totalPageCount; ++pageIndex) {
                    ConfluencePage page = this.pageList.get(pageIndex);
                    if (!isFirstPage && formatting.isSeparatePage()) {
                        this.outputWriter.addPageBreak("wiki-page");
                    }
                    isFirstPage = false;
                    this.progress.calculateProgressValue(this.getNextPhase(firstRound), pageIndex, totalPageCount);
                    TagNode rootNode = this.buildCssAndProcess(page, exportContext);
                    String title = this.outputWriter.getPageTitle(this.bookmarks.getBookmarkByPageId(page.getId()), page.getTitle(), page.getPageHierarchicLevel());
                    this.outputWriter.addPage(page, title, rootNode);
                }
                if (PageNumbersAreaTo.LAST_EXPORTED_PAGE.isStart(formatting)) {
                    this.outputWriter.closePageNumbersStartFromSection();
                    this.outputWriter.addPageNumbersStartFromSection();
                }
                if (formatting.isBackCover() && this.backCoverPage != null) {
                    this.outputWriter.addSectionBreak("cover-page back-cover");
                    TagNode rootNode = this.buildCssAndProcess(this.backCoverPage, exportContext);
                    String title = this.outputWriter.getPageTitle(this.bookmarks.getBookmarkByPageId(this.backCoverPage.getId()), this.backCoverPage.getTitle(), this.backCoverPage.getPageHierarchicLevel());
                    this.outputWriter.addBackCover(this.backCoverPage, title, rootNode);
                }
                this.outputWriter.closePageNumbersStartFromSection();
                this.outputWriter.saveInlineStyles();
                this.outputWriter.finish();
                exportContext.setTotalPageCount(this.outputWriter.getTotalPageCount());
            }
            finally {
                this.outputWriter.cleanUp();
            }
        }
        return this.outputWriter.getIntermediateFile();
    }

    private ProgressData.ProgressPhase getNextPhase(boolean firstRound) {
        return firstRound && this.outputWriter.doWeNeedSecondRound() ? ProgressData.ProgressPhase.GENERATING_PAGES_WITH_FULL_PAGE_NUMBERS : ProgressData.ProgressPhase.CONVERTING_PAGES;
    }

    private void generateBookmarksForEveryPage() throws IOException {
        for (ConfluencePage page : this.pageList) {
            this.generateBookmarksForPage(page);
        }
    }

    private void generateBookmarksForPage(ConfluencePage content) throws IOException {
        this.bookmarks.generateBookmarks(content, this.fragmentUtils.getPageNode(content.getId()));
        content.setTitle(Utils.escapeHtml((String)content.getTitle(), (CleanerProperties)cleanerProperties));
    }

    private void generateBookmarksForFrontCover() throws IOException {
        this.generateBookmarksForPage(this.frontCoverPage);
    }

    private void generateBookmarksForBackCover() throws IOException {
        this.generateBookmarksForPage(this.backCoverPage);
    }

    private void generateBookmarkForTableOfContents(Formatting formatting) throws IOException {
        ConfluencePage tocPage = new ConfluencePage(-3L, formatting.getTocTitle(), "http://tableofcontents/");
        this.bookmarks.generateBookmarks(tocPage, new TagNode(tocPage.getTitle()));
    }

    private String processHeadersFooters(ExportContext exportContext, XmlSerializer serializer, ConfluenceContent page) throws ContentExporterException {
        String headerFooterTemplate = "header-footer-content.vm";
        String headerFooterContent = this.processTemplateWithMetadata(exportContext.getMetadata(), headerFooterTemplate, this.getEffectiveFormatting());
        TagNode headerFooterNode = this.htmlCleaner.clean(headerFooterContent);
        List<PageProcessor> activePageProcessors = this.getActivePageProcessors(headerFooterNode);
        TagNode viewNode = null;
        if (ContentExporter.isViewFormatNeeded(activePageProcessors)) {
            viewNode = this.htmlCleaner.clean(headerFooterContent);
        }
        for (PageProcessor pageProcessor : activePageProcessors) {
            pageProcessor.process(page, headerFooterNode, viewNode, exportContext, this.statistics);
        }
        return serializer.getAsString(headerFooterNode.findElementByName("body", true).findElementByName("div", false));
    }

    private String processTemplateWithMetadata(Metadata metadata, String templateName, Formatting formatting) throws ContentExporterException {
        try {
            VelocityTemplate template = this.resourceLoader.resolveTemplate(templateName);
            Stylesheet stylesheet = (Stylesheet)this.stylesheetRepository.getById(formatting.getStylesheetId());
            String cleanedCustomCss = stylesheet != null ? Jsoup.clean((String)stylesheet.getCss(), (Safelist)Safelist.none()) : "";
            template.put("customStylesheet", cleanedCustomCss);
            template.put("formatting", formatting);
            template.put("metadataConverter", this.metadataVelocityConverter);
            template.put("meta", metadata);
            template.put("dateFormatter", this.dateFormatter);
            template.put("esc", this.escaper);
            template.put("pluginVersion", this.addonInfo.getVersion());
            template.put("bookmarks", this.outputWriter.getBookmarks());
            this.outputWriter.customizeDocumentPrefix(template);
            return template.merge();
        }
        catch (IOException e) {
            throw new ContentExporterException(e);
        }
    }

    private TagNode buildCssAndProcess(ConfluenceContent page, ExportContext exportContext) throws IOException {
        this.buildCombinedCssFile(exportContext);
        return this.process(page, exportContext);
    }

    private TagNode process(ConfluenceContent page, ExportContext exportContext) throws IOException {
        long pageId = page.getId();
        TagNode rootNode = this.fragmentUtils.getPageNode(pageId);
        TagNode viewNode = null;
        List<PageProcessor> activePageProcessors = this.getActivePageProcessors(rootNode);
        if (ContentExporter.isViewFormatNeeded(activePageProcessors)) {
            ConfluencePage pageView = this.contentFetcher.getPage(pageId, EnumSet.of(Fetch.BODY_IN_VIEW), this.statistics);
            viewNode = this.htmlCleaner.clean(pageView.getBody());
        }
        for (PageProcessor pageProcessor : activePageProcessors) {
            pageProcessor.process(page, rootNode, viewNode, exportContext, this.statistics);
        }
        return rootNode;
    }

    private Formatting getEffectiveFormatting() {
        ExportProfile profile;
        Formatting formatting = this.exportParameters.getFormatting();
        if (this.exportParameters.getProfileId() != null && (profile = (ExportProfile)this.profileRepository.getById(this.exportParameters.getProfileId())) != null) {
            formatting = profile.getFormatting();
        }
        return formatting;
    }

    private ConfluencePage getFirstPage() {
        return this.pageList.get(0);
    }

    private List<PageProcessor> getActivePageProcessors(TagNode rootNode) {
        ArrayList<PageProcessor> result = new ArrayList<PageProcessor>();
        for (PageProcessor pageProcessor : this.pageProcessors) {
            PageProcessorAction action = pageProcessor.shouldProcess(rootNode);
            if (action != PageProcessorAction.PROCESS && action != PageProcessorAction.PROCESS_WITH_VIEW_FORMAT) continue;
            if (action == PageProcessorAction.PROCESS_WITH_VIEW_FORMAT) {
                pageProcessor.setViewFormatNeeded(true);
            }
            result.add(pageProcessor);
        }
        return result;
    }

    private static boolean isViewFormatNeeded(List<PageProcessor> pageProcessors) {
        for (PageProcessor pageProcessor : pageProcessors) {
            if (!pageProcessor.isViewFormatNeeded()) continue;
            return true;
        }
        return false;
    }

    protected void createPageProcessors() {
        Formatting formatting = this.getEffectiveFormatting();
        this.pageProcessors.clear();
        this.pageProcessors.add(new SvgPageProcessor());
        this.pageProcessors.addAll(this.outputFormat.getProcessors(this.imageFetcher));
        if (formatting.isFontResize()) {
            this.pageProcessors.add(new FontResizingTablePageProcessor());
        }
        if (formatting.isBreakWord()) {
            this.pageProcessors.add(new WordBreakingTablePageProcessor());
        }
        this.pageProcessors.add(new LinkProcessor(this.outputFormat));
        this.pageProcessors.add(new StyleExtractorProcessor());
        this.pageProcessors.add(new CustomFieldPageProcessor(this.dateFormatter, this.resourceLoader));
    }

    private void initOutputFilename(ConfluencePage firstPage) {
        String filenameExtension = this.exportParameters.getOutputFormat().getExtension();
        String s = String.format(OUTPUT_FILENAME_TEMPLATE, firstPage.getTitle(), firstPage.getVersion(), new SimpleDateFormat(OUTPUT_FILENAME_DATE_FORMAT).format(this.exportTime), filenameExtension);
        this.outputFilename = s.replaceAll(OUTPUT_FILENAME_DISABLED_CHARACTERS_REGEXP, "_").replaceAll("__+", "_");
    }

    public OperationResult getStatus() {
        return this.status;
    }

    public Progress getProgress() {
        return this.progress;
    }

    public String getExportId() {
        return this.exportId;
    }

    public String getOutputFilename() {
        return this.outputFilename;
    }

    public String getOutputContentType() {
        return this.outputFormat.getContentType();
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    private synchronized String createUniqueExportId() {
        int id = downloadCounter++;
        int random = secureRandom.nextInt();
        long result = 0L;
        for (int i = 0; i < 32; ++i) {
            result |= (long)(random & 1);
            result <<= 1;
            result |= (long)(id & 1);
            result <<= 1;
            random >>= 1;
            id >>= 1;
        }
        return Long.toHexString(result);
    }

    public void cleanup() {
        try {
            logger.debug("Cleanup single working directory: {}", new Object[]{this.workingDirectory});
            FileUtils.deleteDirectory((File)this.workingDirectory);
        }
        catch (IOException e) {
            logger.error("Can't delete working directory: {}", new Object[]{this.workingDirectory, e});
        }
    }
}

