/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import hu.metainf.plugin.confluence.contentexporter.model.HeaderFooter;
import hu.metainf.plugin.confluence.contentexporter.model.Margin;
import hu.metainf.plugin.confluence.contentexporter.model.PageNumbersArea;
import hu.metainf.plugin.confluence.contentexporter.model.PageSettings;
import hu.metainf.plugin.confluence.contentexporter.model.TocMode;
import hu.metainf.plugin.confluence.contentexporter.model.Unit;
import java.util.ArrayList;
import java.util.List;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Formatting {
    @JsonProperty(value="frontCover")
    private Long frontCover;
    @JsonProperty(value="backCover")
    private Long backCover;
    @JsonProperty(value="toc")
    private boolean tableOfContents;
    @JsonProperty(value="tocTitle")
    private String tocTitle = "Table of Contents";
    @JsonProperty(value="tocLevel")
    private int tocLevel = 6;
    @JsonProperty(value="tocMode")
    private TocMode tocMode = TocMode.FLAT;
    @JsonProperty(value="pageNumbersArea")
    private PageNumbersArea pageNumbersArea = new PageNumbersArea();
    @JsonProperty(value="stylesheetId")
    private long stylesheetId;
    @JsonProperty(value="headerFooters")
    private List<HeaderFooter> headerFooters = new ArrayList<HeaderFooter>();
    @JsonProperty(value="pageSettings")
    private PageSettings pageSettings = PageSettings.DEFAULT;
    @JsonProperty(value="unit")
    private Unit unit = Unit.IN;
    @JsonProperty(value="margins")
    private List<Margin> margins = new ArrayList<Margin>(){
        {
            this.add(Margin.DEFAULT);
        }
    };
    @JsonProperty(value="fontResize")
    private boolean fontResize = true;
    @JsonProperty(value="breakWord")
    private boolean breakWord;
    @JsonProperty(value="separatePage")
    private boolean separatePage = true;
    @JsonProperty(value="selectedFont")
    private Long selectedFont;
    @JsonProperty(value="additionalFonts")
    private Long[] additionalFonts;
    @JsonProperty(value="headingNumbering")
    private boolean headingNumbering;

    public boolean isFrontCover() {
        return this.frontCover != null;
    }

    public boolean isBackCover() {
        return this.backCover != null;
    }

    public void setFrontCover(Long frontCover) {
        this.frontCover = frontCover;
    }

    public Long getFrontCover() {
        return this.frontCover;
    }

    public Long getBackCover() {
        return this.backCover;
    }

    public void setBackCover(Long backCover) {
        this.backCover = backCover;
    }

    public boolean isTableOfContents() {
        return this.tableOfContents;
    }

    public void setTableOfContents(boolean tableOfContents) {
        this.tableOfContents = tableOfContents;
    }

    public long getStylesheetId() {
        return this.stylesheetId;
    }

    public void setStylesheetId(long stylesheetId) {
        this.stylesheetId = stylesheetId;
    }

    public List<HeaderFooter> getHeaderFooters() {
        return this.headerFooters;
    }

    public void setHeaderFooters(List<HeaderFooter> headerFooters) {
        this.headerFooters = headerFooters;
    }

    public PageSettings getPageSettings() {
        return this.pageSettings;
    }

    public void setPageSettings(PageSettings pageSettings) {
        this.pageSettings = pageSettings;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public List<Margin> getMargins() {
        return this.margins;
    }

    public void setMargins(List<Margin> margins) {
        this.margins = margins;
    }

    public int getTocLevel() {
        return this.tocLevel;
    }

    public void setTocLevel(int tocLevel) {
        this.tocLevel = tocLevel;
    }

    public TocMode getTocMode() {
        return this.tocMode;
    }

    public void setTocMode(TocMode tocMode) {
        this.tocMode = tocMode;
    }

    public PageNumbersArea getPageNumbersArea() {
        return this.pageNumbersArea;
    }

    public void setPageNumbersArea(PageNumbersArea pageNumbersArea) {
        this.pageNumbersArea = pageNumbersArea;
    }

    public boolean isFontResize() {
        return this.fontResize;
    }

    public void setFontResize(boolean fontResize) {
        this.fontResize = fontResize;
    }

    public void setBreakWord(boolean breakWord) {
        this.breakWord = breakWord;
    }

    public boolean isBreakWord() {
        return this.breakWord;
    }

    public boolean isSeparatePage() {
        return this.separatePage;
    }

    public void setSeparatePage(boolean separatePage) {
        this.separatePage = separatePage;
    }

    public String getTocTitle() {
        return this.tocTitle;
    }

    public void setTocTitle(String tocTitle) {
        this.tocTitle = tocTitle;
    }

    public void setSelectedFont(Long selectedFont) {
        this.selectedFont = selectedFont;
    }

    public Long getSelectedFont() {
        return this.selectedFont;
    }

    public Long[] getAdditionalFonts() {
        return this.additionalFonts;
    }

    public void setAdditionalFonts(Long[] additionalFonts) {
        this.additionalFonts = additionalFonts;
    }

    public boolean isHeadingNumbering() {
        return this.headingNumbering;
    }

    public void setHeadingNumbering(boolean headingNumbering) {
        this.headingNumbering = headingNumbering;
    }

    public boolean isTotalPageCountNeeded() {
        boolean result = false;
        for (HeaderFooter headerFooter : this.headerFooters) {
            if (!headerFooter.isTotalPageCountNeeded()) continue;
            result = true;
            break;
        }
        return result;
    }
}

