/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.standalone;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.user.User;
import hu.metainf.plugin.confluence.contentexporter.dao.ConfigurationRepository;
import hu.metainf.plugin.confluence.contentexporter.model.Configuration;
import hu.metainf.plugin.confluence.contentexporter.model.ExportPermissions;

public class StandalonePermissionUtil {
    public static boolean hasSpaceExportPermission(User user, AbstractPage page, SpacePermissionManager spacePermissionManager, ConfigurationRepository configurationRepository) {
        Configuration configuration = configurationRepository.load();
        boolean result = configuration.getExportPermission().equals(ExportPermissions.CONFLUENCE_PERMISSION.toString()) ? spacePermissionManager.hasPermission("EXPORTSPACE", page.getSpace(), user) : spacePermissionManager.hasPermission("VIEWSPACE", page.getSpace(), user);
        return result;
    }

    public static boolean canUserAccessToPage(User user, AbstractPage page, PermissionManager permissionManager) {
        return page instanceof Page && permissionManager.hasPermission(user, Permission.VIEW, (Object)page);
    }
}

