/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import proguard.annotation.KeepClassMembers;

@KeepClassMembers
public class ProgressData {
    private ProgressPhase phase;
    private Integer progressValue;

    public ProgressData(ProgressPhase phase) {
        this.phase = phase;
        this.progressValue = phase.getStartValue();
    }

    public void incrementProgressValue() {
        this.progressValue = Integer.min(100, this.progressValue + 1);
    }

    public Integer getProgressValue() {
        return this.progressValue;
    }

    public void setProgressValue(Integer progressValue) {
        this.progressValue = progressValue;
    }

    public ProgressPhase getPhase() {
        return this.phase;
    }

    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString((Object)this);
        }
        catch (IOException ioe) {
            return "";
        }
    }

    public static enum ProgressPhase {
        FETCHING_PAGES(0),
        GENERATING_PAGES(25),
        GENERATING_PAGES_WITH_FULL_PAGE_NUMBERS(50),
        CONVERTING_PAGES(90);

        private int startValue;

        private ProgressPhase(int startValue) {
            this.startValue = startValue;
        }

        public int getStartValue() {
            return this.startValue;
        }
    }
}

