/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import hu.metainf.plugin.confluence.contentexporter.controllers.MessageResolver;
import hu.metainf.plugin.confluence.contentexporter.exporter.OperationResult;
import hu.metainf.plugin.util.ErrorCollection;
import java.util.List;
import java.util.Map;

public class ErrorToJsonConverter {
    private final MessageResolver messageResolver;

    public ErrorToJsonConverter(MessageResolver messageResolver) {
        this.messageResolver = messageResolver;
    }

    public JsonNode toJson(ErrorCollection errorCollection) {
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayNode result = objectMapper.createArrayNode();
        for (Map.Entry<String, String> entry : errorCollection.getErrorMessages().entrySet()) {
            String key = entry.getKey();
            String message = entry.getValue();
            List<Object> arguments = errorCollection.getErrorArguments().get(key);
            String translatedMessage = this.messageResolver.resolve(message, arguments);
            ObjectNode errorNode = result.addObject();
            errorNode.put("key", key);
            errorNode.put("message", translatedMessage);
        }
        return result;
    }

    public ObjectNode operationResultToJson(OperationResult operationResult) {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode jsonNode = objectMapper.createObjectNode();
        boolean success = operationResult.isSuccess();
        jsonNode.put("success", success);
        if (!success) {
            ErrorCollection errors = operationResult.getErrors();
            jsonNode.put("message", this.messageResolver.resolve(errors.getGlobalErrorMessage(), errors.getGlobalErrorArguments()));
            jsonNode.put("details", this.messageResolver.resolve(errors.getGlobalErrorDetails(), errors.getGlobalErrorDetailsArguments()));
        }
        return jsonNode;
    }
}

