/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.controllers;

import com.fasterxml.jackson.databind.JsonNode;
import hu.metainf.plugin.confluence.contentexporter.exporter.io.HttpUtil;
import hu.metainf.plugin.confluence.contentexporter.exporter.io.IoUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;

class ActionUtil {
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final String CONTENT_TYPE_TEXT_PLAIN = "text/plain";

    ActionUtil() {
    }

    static void sendJsonResponse(JsonNode jsonNode) throws IOException {
        ActionUtil.sendJsonResponse(jsonNode.toString());
    }

    static void sendJsonResponse(String json) throws IOException {
        HttpServletResponse response = ActionUtil.setHeadersForJsonResponse();
        ServletOutputStream os = response.getOutputStream();
        os.write(json.getBytes("UTF-8"));
        os.close();
    }

    private static HttpServletResponse setHeadersForJsonResponse() {
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setContentType(CONTENT_TYPE_JSON);
        response.setCharacterEncoding("UTF-8");
        HttpUtil.setNoCacheHeaders(response);
        return response;
    }

    static void sendFileResponse(String filename, String contentType, File file, String hash) throws IOException {
        HttpServletResponse response = ServletActionContext.getResponse();
        HttpUtil.setNoCacheHeaders(response);
        response.setContentType(contentType);
        filename = HttpUtil.encodeURIComponent(filename);
        response.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + filename + ";");
        response.setHeader("Set-Cookie", "content-export-" + hash + "=success; path=/");
        IoUtil.copy(file, (OutputStream)response.getOutputStream());
    }

    static void sendBadRequest(String message) throws IOException {
        ActionUtil.setBadRequest();
        ActionUtil.sendTextResponse(message);
    }

    static void sendBadRequest(JsonNode json) throws IOException {
        ActionUtil.setBadRequest();
        ActionUtil.sendJsonResponse(json);
    }

    private static void setBadRequest() {
        HttpServletResponse response = ServletActionContext.getResponse();
        HttpUtil.setNoCacheHeaders(response);
        response.setStatus(400);
    }

    private static void sendTextResponse(String message) throws IOException {
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setContentType(CONTENT_TYPE_TEXT_PLAIN);
        if (message != null) {
            ServletOutputStream os = response.getOutputStream();
            os.write(message.getBytes("UTF-8"));
            os.close();
        }
    }

    public static void sendInternalServerError(JsonNode json) throws IOException {
        ActionUtil.setInternalServerError();
        ActionUtil.sendJsonResponse(json);
    }

    public static void setInternalServerError() {
        HttpServletResponse response = ServletActionContext.getResponse();
        HttpUtil.setNoCacheHeaders(response);
        response.setStatus(500);
    }
}

