/*
 * Decompiled with CFR 0.152.
 */
package com.keysight.html.elements.rest;

import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.keysight.html.elements.rest.RestResponse;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class RestService {
    private static final Logger log = LoggerFactory.getLogger(RestService.class);
    private final SettingsManager settingsManager;
    private final VelocityHelperService velocityHelperService;

    @Inject
    public RestService(SettingsManager settingsManager, VelocityHelperService velocityHelperService) {
        this.settingsManager = settingsManager;
        this.velocityHelperService = velocityHelperService;
    }

    @GET
    @Path(value="help/html5-multimedia")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response html5MultimediaHelp() {
        String title = "HTML5 Multimedia Help";
        String bodyTemplate = "/com/keysight/html-elements/templates/html5-multimedia-help.vm";
        return this.getMacroHelp(title, bodyTemplate);
    }

    @GET
    @Path(value="help/multimedia")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response multimediaHelp() {
        String title = "HTML5 Multimedia Help";
        String bodyTemplate = "/com/keysight/html-elements/templates/html5-multimedia-help.vm";
        return this.getMacroHelp(title, bodyTemplate);
    }

    @GET
    @Path(value="help/compact-form")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response compactFormHelp() {
        String title = "Compact Form Help";
        String bodyTemplate = "/com/keysight/html-elements/templates/compact-form-help.vm";
        return this.getMacroHelp(title, bodyTemplate);
    }

    @GET
    @Path(value="help/aui-tab")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response auiTabHelp() {
        String title = "AUI Tab Help";
        String bodyTemplate = "/com/keysight/html-elements/templates/aui-tab-help.vm";
        return this.getMacroHelp(title, bodyTemplate);
    }

    @GET
    @Path(value="help/aui-tab-group")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response auiTabGroupHelp() {
        String title = "AUI Tab Group Help";
        String bodyTemplate = "/com/keysight/html-elements/templates/aui-tab-group-help.vm";
        return this.getMacroHelp(title, bodyTemplate);
    }

    @GET
    @Path(value="help/aui-child-tabs")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response auiChildTabsHelp() {
        String title = "AUI Child Tabs Help";
        String bodyTemplate = "/com/keysight/html-elements/templates/aui-child-tabs-help.vm";
        return this.getMacroHelp(title, bodyTemplate);
    }

    @GET
    @Path(value="help/aui-pages-tabs")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response auiPagesTabsHelp() {
        String title = "AUI Pages Tabs Help";
        String bodyTemplate = "/com/keysight/html-elements/templates/aui-pages-tabs-help.vm";
        return this.getMacroHelp(title, bodyTemplate);
    }

    @GET
    @Path(value="help/aui-pages-by-label-tabs")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response auiPagesByLabelTabsHelp() {
        String title = "AUI Pages By Label Tabs Help";
        String bodyTemplate = "/com/keysight/html-elements/templates/aui-pages-by-label-tabs-help.vm";
        return this.getMacroHelp(title, bodyTemplate);
    }

    @GET
    @Path(value="help/aui-buttons")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response auiButtonsHelp() {
        String title = "AUI Button Help";
        String bodyTemplate = "/com/keysight/html-elements/templates/aui-button-help.vm";
        return this.getMacroHelp(title, bodyTemplate);
    }

    @GET
    @Path(value="help/extra-table-properties")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response extraTablePropertiesHelp() {
        String title = "Extra Table Properties Help";
        String bodyTemplate = "/com/keysight/html-elements/templates/extra-table-properties-help.vm";
        return this.getMacroHelp(title, bodyTemplate);
    }

    @GET
    @Path(value="help/authors-only-block")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response authorsOnlyBlockHelp() {
        String title = "Authors Only Block Help";
        String bodyTemplate = "/com/keysight/html-elements/templates/authors-only-block-help.vm";
        return this.getMacroHelp(title, bodyTemplate);
    }

    @GET
    @Path(value="help/layout-width")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response layoutWidthHelp() {
        String title = "Layout Width Help";
        String bodyTemplate = "/com/keysight/html-elements/templates/layout-width-help.vm";
        return this.getMacroHelp(title, bodyTemplate);
    }

    @GET
    @Path(value="help/block")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response blockHelp() {
        String title = "Block Help";
        String bodyTemplate = "/com/keysight/html-elements/templates/block-help.vm";
        return this.getMacroHelp(title, bodyTemplate);
    }

    @GET
    @Path(value="help/link-to-window")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response linkToWindowHelp() {
        String title = "Link To Window Help";
        String bodyTemplate = "/com/keysight/html-elements/templates/link-to-window-help.vm";
        return this.getMacroHelp(title, bodyTemplate);
    }

    @GET
    @Path(value="help/anonymous-only-block")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response anonymousOnlyBlockHelp() {
        String title = "Anonymous Only Block";
        String bodyTemplate = "/com/keysight/html-elements/templates/anonymous-only-block-help.vm";
        return this.getMacroHelp(title, bodyTemplate);
    }

    @GET
    @Path(value="help/page-info-block")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response pageInfoHelp() {
        String title = "Page Info Block";
        String bodyTemplate = "/com/keysight/html-elements/templates/page-info-help.vm";
        return this.getMacroHelp(title, bodyTemplate);
    }

    private Response getMacroHelp(String title, String bodyTemplate) {
        StringBuilder html = new StringBuilder();
        String headerTemplate = "/com/keysight/html-elements/templates/help-header.vm";
        String footerTemplate = "/com/keysight/html-elements/templates/help-footer.vm";
        String fossTemplate = "/com/keysight/html-elements/templates/foss.vm";
        Map velocityContext = this.velocityHelperService.createDefaultVelocityContext();
        velocityContext.put("title", title);
        velocityContext.put("baseUrl", this.settingsManager.getGlobalSettings().getBaseUrl());
        html.append(this.velocityHelperService.getRenderedTemplate(headerTemplate, velocityContext));
        html.append(this.velocityHelperService.getRenderedTemplate(bodyTemplate, velocityContext));
        html.append(this.velocityHelperService.getRenderedTemplate(fossTemplate, velocityContext));
        html.append(this.velocityHelperService.getRenderedTemplate(footerTemplate, velocityContext));
        return Response.ok((Object)new RestResponse(html.toString())).build();
    }
}

