/*
 * Decompiled with CFR 0.152.
 */
package com.keysight.html.elements.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageInfo
extends BaseMacro
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(PageInfo.class);
    private static final String INCLUDE_DESCRIPTIVE_TEXT = "include-descriptive-text";
    private static final String LIST_REPRESENTATION = "list-representation";
    private static final String UNORDERED_LIST = "Unordered List";
    private static final String NEW_LINE = "New Line";
    private static final String COMMA_SEPARATED = "Comma Separated";
    private static final String INCLUDE_PAGE_ID = "include-page-id";
    private static final String INCLUDE_ORIGINAL_AUTHOR = "include-original-author";
    private static final String INCLUDE_MOST_RECENT_AUTHOR = "include-latest-author";
    private static final String INCLUDE_CREATION_DATE = "include-creation-date";
    private static final String INCLUDE_LAST_MODIFICATION_DATE = "include-last-modification-date";
    private final SimpleDateFormat LONG_DATE_FORMAT = new SimpleDateFormat("EEEE MMMM d, YYYY");

    public String execute(Map<String, String> parameters, String body, ConversionContext context) throws MacroExecutionException {
        StringBuilder html = new StringBuilder();
        ContentEntityObject entity = context.getEntity();
        boolean commaSeparated = true;
        boolean newLineSeparated = false;
        boolean listSeparated = false;
        String listRepresentation = COMMA_SEPARATED;
        ArrayList<String> items = new ArrayList<String>();
        if (parameters.containsKey(LIST_REPRESENTATION)) {
            listRepresentation = parameters.get(LIST_REPRESENTATION);
        }
        if (listRepresentation.matches(UNORDERED_LIST)) {
            commaSeparated = false;
            newLineSeparated = false;
            listSeparated = true;
        } else if (listRepresentation.matches(NEW_LINE)) {
            commaSeparated = false;
            newLineSeparated = true;
            listSeparated = false;
        }
        if (listSeparated) {
            html.append("<ul>\n");
            if (parameters.containsKey(INCLUDE_PAGE_ID)) {
                html.append("   <li>" + this.getPageId(parameters, entity) + "</li>\n");
            }
            if (parameters.containsKey(INCLUDE_ORIGINAL_AUTHOR)) {
                html.append("   <li>" + this.getOriginalAuthor(parameters, entity) + "</li>\n");
            }
            if (parameters.containsKey(INCLUDE_CREATION_DATE)) {
                html.append("   <li>" + this.getCreationDate(parameters, entity) + "</li>\n");
            }
            if (parameters.containsKey(INCLUDE_MOST_RECENT_AUTHOR)) {
                html.append("   <li>" + this.getMostRecentAuthor(parameters, entity) + "</li>\n");
            }
            if (parameters.containsKey(INCLUDE_LAST_MODIFICATION_DATE)) {
                html.append("   <li>" + this.getLastModificationDate(parameters, entity) + "</li>\n");
            }
            html.append("</ul>\n");
        } else {
            if (parameters.containsKey(INCLUDE_PAGE_ID)) {
                items.add(this.getPageId(parameters, entity));
            }
            if (parameters.containsKey(INCLUDE_ORIGINAL_AUTHOR)) {
                items.add(this.getOriginalAuthor(parameters, entity));
            }
            if (parameters.containsKey(INCLUDE_CREATION_DATE)) {
                items.add(this.getCreationDate(parameters, entity));
            }
            if (parameters.containsKey(INCLUDE_MOST_RECENT_AUTHOR)) {
                items.add(this.getMostRecentAuthor(parameters, entity));
            }
            if (parameters.containsKey(INCLUDE_LAST_MODIFICATION_DATE)) {
                items.add(this.getLastModificationDate(parameters, entity));
            }
            if (newLineSeparated) {
                html.append(String.join((CharSequence)"<br />\n", items));
            } else {
                html.append(String.join((CharSequence)",", items));
            }
        }
        return html.toString();
    }

    private String getPageId(Map<String, String> parameters, ContentEntityObject entity) {
        Object html = null;
        html = parameters.containsKey(INCLUDE_DESCRIPTIVE_TEXT) ? "The page ID is " + entity.getIdAsString() : entity.getIdAsString().toString();
        return html;
    }

    private String getOriginalAuthor(Map<String, String> parameters, ContentEntityObject entity) {
        Object html = null;
        html = parameters.containsKey(INCLUDE_DESCRIPTIVE_TEXT) ? "The original author is " + entity.getCreatorName() : entity.getCreatorName();
        return html;
    }

    private String getMostRecentAuthor(Map<String, String> parameters, ContentEntityObject entity) {
        Object html = null;
        html = parameters.containsKey(INCLUDE_DESCRIPTIVE_TEXT) ? "The last change was made by " + entity.getLastModifierName() : entity.getLastModifierName();
        return html;
    }

    private String getCreationDate(Map<String, String> parameters, ContentEntityObject entity) {
        Object html = null;
        html = parameters.containsKey(INCLUDE_DESCRIPTIVE_TEXT) ? "The first version was created on " + this.LONG_DATE_FORMAT.format(entity.getCreationDate()) : this.LONG_DATE_FORMAT.format(entity.getCreationDate());
        return html;
    }

    private String getLastModificationDate(Map<String, String> parameters, ContentEntityObject entity) {
        Object html = null;
        html = parameters.containsKey(INCLUDE_DESCRIPTIVE_TEXT) ? "The content was last modified on " + this.LONG_DATE_FORMAT.format(entity.getLastModificationDate()) : this.LONG_DATE_FORMAT.format(entity.getLastModificationDate());
        return html;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.ALL;
    }

    public String execute(Map params, String body, RenderContext renderContext) throws MacroException {
        try {
            return this.execute((Map<String, String>)params, body, (ConversionContext)new DefaultConversionContext(renderContext));
        }
        catch (MacroExecutionException e) {
            throw new MacroException((Throwable)e);
        }
    }
}

