/*
 * Decompiled with CFR 0.152.
 */
package com.keysight.html.elements.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.renderer.v2.RenderUtils;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTML5Multimedia
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(HTML5Multimedia.class);
    private final AttachmentManager attachmentManager;
    private final SettingsManager settingsManager;
    private final VelocityHelperService velocityHelperService;
    public static final String MACRO_EDITOR_PAGE_KEY = "page";
    public static final String MACRO_EDITOR_ATTACHMENT_KEY = "name";
    public static final String MACRO_EDITOR_URL_KEY = "url";
    public static final String MACRO_EDITOR_URL_MEDIA_TYPE_KEY = "url-media-type";
    public static final String MACRO_EDITOR_POSTER_KEY = "poster";
    public static final String MACRO_EDITOR_PRESET_KEY = "preset";
    public static final String MACRO_EDITOR_HEIGHT_KEY = "height";
    public static final String MACRO_EDITOR_WIDTH_KEY = "width";
    public static final String MACRO_EDITOR_LOOP_KEY = "loop";
    public static final String MACRO_EDITOR_AUTOSTART_KEY = "autostart";
    public static final String MACRO_EDITOR_AUTOPLAY_KEY = "autoplay";
    public static final String MACRO_EDITOR_ADD_DOWNLOAD_LINK_KEY = "add-download-link";
    public static final String MACRO_EDITOR_ADD_DOWNLOAD_BUTTON_KEY = "add-download-button";
    public static final String MACRO_EDITOR_ADD_FULLSCREEN_BUTTON_KEY = "add-fullscreen-button";
    public static final String MACRO_EDITOR_IS_AUDIO_KEY = "is-audio";
    public static final String MACRO_EDITOR_ADD_CONTROLS_KEY = "add-contols";
    public static final String INCLUDE_MEDIA_KEY = "includeMedia";
    public static final String ATTACHMENT_KEY = "attachment";
    public static final String POSTER_KEY = "poster";
    public static final String HEIGHT_KEY = "height";
    public static final String WIDTH_KEY = "width";
    public static final String LOOP_KEY = "loop";
    public static final String AUTOPLAY_KEY = "autoplay";
    public static final String ADD_DOWNLOAD_LINK_KEY = "addDownloadLink";
    public static final String ADD_DOWNLOAD_BUTTON_KEY = "addDownloadButton";
    public static final String ADD_FULLSCREEN_BUTTON_KEY = "addFullscreenButton";
    public static final String ADD_CONTROLS_KEY = "addControls";
    public static final String URL_KEY = "url";
    public static final String FILE_EXTENSION_KEY = "fileextension";

    @Inject
    public HTML5Multimedia(AttachmentManager attachmentManager, SettingsManager settingsManager, VelocityHelperService velocityHelperService) {
        this.attachmentManager = attachmentManager;
        this.settingsManager = settingsManager;
        this.velocityHelperService = velocityHelperService;
    }

    public String execute(Map<String, String> parameters, String body, ConversionContext context) throws MacroExecutionException {
        Map velocityContext = this.velocityHelperService.createDefaultVelocityContext();
        String videoTemplate = "/com/keysight/html-elements/templates/html5-video.vm";
        String audioTemplate = "/com/keysight/html-elements/templates/html5-audio.vm";
        String template = "";
        String result = "";
        String fileExtension = "";
        Object url = null;
        String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        if (parameters.containsKey("url")) {
            url = parameters.get("url");
            if (parameters.containsKey(MACRO_EDITOR_URL_MEDIA_TYPE_KEY) && !StringUtils.isEmpty((CharSequence)parameters.get(MACRO_EDITOR_URL_MEDIA_TYPE_KEY))) {
                fileExtension = parameters.get(MACRO_EDITOR_URL_MEDIA_TYPE_KEY);
            } else if (((String)url).length() > 3) {
                fileExtension = ((String)url).substring(((String)url).length() - 3);
            }
            velocityContext.put(INCLUDE_MEDIA_KEY, "true");
        } else if (parameters.containsKey(MACRO_EDITOR_ATTACHMENT_KEY)) {
            String fileName = parameters.get(MACRO_EDITOR_ATTACHMENT_KEY);
            Attachment attachment = this.attachmentManager.getAttachment(context.getEntity(), fileName);
            url = baseUrl + attachment.getDownloadPath();
            fileExtension = attachment.getFileExtension();
        }
        if (url != null) {
            velocityContext.put(ADD_CONTROLS_KEY, "controls");
            velocityContext.put("url", url);
            velocityContext.put(FILE_EXTENSION_KEY, fileExtension);
            if (parameters.containsKey("poster")) {
                velocityContext.put("poster", parameters.get("poster"));
            }
            if (parameters.containsKey("loop")) {
                velocityContext.put("loop", "true");
            }
            if (parameters.containsKey("autoplay")) {
                velocityContext.put("autoplay", "true");
            } else if (parameters.containsKey(MACRO_EDITOR_AUTOSTART_KEY)) {
                velocityContext.put("autoplay", "true");
            }
            if (parameters.containsKey(MACRO_EDITOR_ADD_DOWNLOAD_LINK_KEY)) {
                velocityContext.put(ADD_DOWNLOAD_LINK_KEY, "true");
            }
            if (parameters.containsKey(MACRO_EDITOR_ADD_DOWNLOAD_BUTTON_KEY)) {
                velocityContext.put(ADD_DOWNLOAD_BUTTON_KEY, "true");
            }
            if (parameters.containsKey(MACRO_EDITOR_ADD_FULLSCREEN_BUTTON_KEY)) {
                velocityContext.put(ADD_FULLSCREEN_BUTTON_KEY, "true");
            }
            if (parameters.containsKey(MACRO_EDITOR_PRESET_KEY)) {
                String preset = parameters.get(MACRO_EDITOR_PRESET_KEY);
                if (preset.equals("640x480 (4:3 VGA)")) {
                    velocityContext.put("width", "640");
                    velocityContext.put("height", "480");
                } else if (preset.equals("800x600 (4:3 SVGA)")) {
                    velocityContext.put("width", "800");
                    velocityContext.put("height", "600");
                } else if (preset.equals("1024x768 (4:3 XGA)")) {
                    velocityContext.put("width", "1024");
                    velocityContext.put("height", "768");
                } else if (preset.equals("1600x1200 (4:3 SXGA+)")) {
                    velocityContext.put("width", "1600");
                    velocityContext.put("height", "1200");
                } else if (preset.equals("1280x1024 (5:4 SXGA)")) {
                    velocityContext.put("width", "1280");
                    velocityContext.put("height", "1024");
                } else if (preset.equals("640x360 (16:9)")) {
                    velocityContext.put("width", "640");
                    velocityContext.put("height", "360");
                } else if (preset.equals("960x540 (16:9 qHD)")) {
                    velocityContext.put("width", "960");
                    velocityContext.put("height", "540");
                } else if (preset.equals("1280x720 (16:9 HD)")) {
                    velocityContext.put("width", "1280");
                    velocityContext.put("height", "720");
                } else if (preset.equals("1920x1080 (16:9 Full HD)")) {
                    velocityContext.put("width", "1920");
                    velocityContext.put("height", "1080");
                }
            } else {
                if (parameters.containsKey("width")) {
                    velocityContext.put("width", parameters.get("width"));
                }
                if (parameters.containsKey("height")) {
                    velocityContext.put("height", parameters.get("height"));
                }
            }
            template = parameters.containsKey(MACRO_EDITOR_IS_AUDIO_KEY) ? audioTemplate : (fileExtension.equals("mp3") || fileExtension.equals("wav") ? audioTemplate : videoTemplate);
            result = this.velocityHelperService.getRenderedTemplate(template, velocityContext);
        } else {
            result = RenderUtils.blockError((String)"HTML5 Multimedia Error: No Attachment or URL specified", (String)"");
        }
        return result;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

