/*
 * Decompiled with CFR 0.152.
 */
package com.keysight.html.elements.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtraTableProperties
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(ExtraTableProperties.class);
    private static final String TABLE_WIDTH_KEY = "table-width";
    private static final String COLUMN_WIDTHS_KEY = "column-widths";
    private static final String ROW_KEY = "row";
    private static final String HIDE_BORDER_KEY = "hide-border";
    protected final XhtmlContent xhtmlUtils;

    @Inject
    public ExtraTableProperties(XhtmlContent xhtmlUtils) {
        this.xhtmlUtils = xhtmlUtils;
    }

    public String execute(Map<String, String> parameters, String body, ConversionContext context) throws MacroExecutionException {
        String tableWidth = "";
        String columnWidths = "";
        String row = "1";
        Object divClass = "keysight-table-width";
        if (parameters.containsKey(HIDE_BORDER_KEY)) {
            divClass = (String)divClass + " keysight-no-table-border";
        }
        if (parameters.containsKey(TABLE_WIDTH_KEY)) {
            tableWidth = parameters.get(TABLE_WIDTH_KEY);
        }
        if (parameters.containsKey(COLUMN_WIDTHS_KEY)) {
            columnWidths = parameters.get(COLUMN_WIDTHS_KEY);
        }
        if (parameters.containsKey(ROW_KEY)) {
            row = parameters.get(ROW_KEY);
        }
        return "<div class=\"" + (String)divClass + "\" row=\"" + row + "\" table-width=\"" + tableWidth + "\"\ncolumn-widths=\"" + columnWidths + "\" >\n" + body + "</div>\n";
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

