/*
 * Decompiled with CFR 0.152.
 */
package com.keysight.html.elements.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorsOnlyBlock
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(AuthorsOnlyBlock.class);
    private final PermissionManager permissionManager;

    @Inject
    public AuthorsOnlyBlock(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public String execute(Map<String, String> parameters, String body, ConversionContext context) throws MacroExecutionException {
        if (this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.EDIT, (Object)context.getEntity())) {
            if (parameters.containsKey("no-border")) {
                return body;
            }
            return "<div class=\"panel private-content-container\">\n   <div class=\"private-content private-content-top private-content-header\">This content is only viewable to those who can edit the page.</div>\n   <div class=\"private-content private-content-body\">" + body + "</div></div>\n";
        }
        return "";
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

