/*
 * Decompiled with CFR 0.152.
 */
package com.keysight.html.elements.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.Format;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.RequiresFormat;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionHandler;
import com.atlassian.confluence.xhtml.api.MacroDefinitionMarshallingStrategy;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.renderer.v2.RenderUtils;
import com.keysight.html.elements.helpers.TabInfo;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuiTabGroup
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(AuiTabGroup.class);
    public static final String TITLE_KEY = "title";
    public static final String VERTICAL_KEY = "vertical";
    public static final String ORIENTATION_KEY = "orientation";
    public static final String ACTIVE_KEY = "active";
    public static final String ID_KEY = "id";
    public static final String LEFT_TITLE_TRUNCATION_COUNT_KEY = "ltrunc";
    public static final String RIGHT_TITLE_TRUNCATION_COUNT_KEY = "rtrunc";
    public static final String RESPONSIVE_KEY = "responsive";
    public static final String PERSISTENCE_KEY = "persistence";
    protected final VelocityHelperService velocityHelperService;
    protected final XhtmlContent xhtmlUtils;

    @Inject
    public AuiTabGroup(VelocityHelperService velocityHelperService, XhtmlContent xhtmlUtils) {
        this.velocityHelperService = velocityHelperService;
        this.xhtmlUtils = xhtmlUtils;
    }

    @RequiresFormat(value=Format.Storage)
    public String execute(Map<String, String> parameters, String body, ConversionContext context) throws MacroExecutionException {
        ArrayList<TabInfo> tabs = null;
        String template = "/com/keysight/html-elements/templates/aui-tab-group.vm";
        Map velocityContext = this.velocityHelperService.createDefaultVelocityContext();
        String macroId = "macroId";
        try {
            MacroDefinition macroDefinition = (MacroDefinition)context.getProperty("macroDefinition");
            Optional option = macroDefinition.getMacroIdentifier();
            macroId = ((MacroId)option.get()).getId();
        }
        catch (Exception e) {
            macroId = RandomStringUtils.randomAlphanumeric((int)16);
        }
        velocityContext.put("macroId", macroId);
        if (parameters.containsKey(VERTICAL_KEY)) {
            velocityContext.put(ORIENTATION_KEY, "vertical-tabs");
        } else {
            velocityContext.put(ORIENTATION_KEY, "horizontal-tabs");
        }
        if (parameters.containsKey(RESPONSIVE_KEY)) {
            velocityContext.put(RESPONSIVE_KEY, "data-aui-responsive=true");
        }
        if (parameters.containsKey(PERSISTENCE_KEY)) {
            velocityContext.put(PERSISTENCE_KEY, "data-aui-persist=true");
        }
        try {
            tabs = this.getTabs(parameters, body, context);
        }
        catch (Exception e) {
            throw new MacroExecutionException((Throwable)e);
        }
        for (int i = 0; i < tabs.size(); ++i) {
            ((TabInfo)tabs.get(i)).setTabId("aui-tab-uid-" + macroId + "-" + i);
            ((TabInfo)tabs.get(i)).setPaneId("aui-pane-uid-" + macroId + "-" + i);
        }
        velocityContext.put("tabs", tabs);
        if (context.getOutputType().matches("(word|pdf)")) {
            velocityContext.put("pdfOrWordOutput", "true");
        }
        if (this.ShowPageInfo()) {
            velocityContext.put("show-tab-info", "true");
        }
        if (tabs.size() > 0) {
            return this.velocityHelperService.getRenderedTemplate(template, velocityContext);
        }
        return RenderUtils.blockError((String)"No pages found.", (String)"");
    }

    protected boolean ShowPageInfo() {
        return false;
    }

    protected ArrayList<TabInfo> getTabs(Map<String, String> parameters, String body, ConversionContext context) throws MacroExecutionException {
        final ArrayList macros = new ArrayList();
        ArrayList<TabInfo> tabs = new ArrayList<TabInfo>();
        TabInfo tabInfo = null;
        boolean activeTabSet = false;
        try {
            this.xhtmlUtils.handleMacroDefinitions(body, context, new MacroDefinitionHandler(){

                public void handle(MacroDefinition macroDefinition) {
                    macros.add(macroDefinition);
                }
            }, MacroDefinitionMarshallingStrategy.MARSHALL_MACRO);
        }
        catch (XhtmlException e) {
            throw new MacroExecutionException((Throwable)e);
        }
        if (!macros.isEmpty()) {
            for (MacroDefinition macroDefinition : macros) {
                if (!macroDefinition.getName().equals("aui-tab") && !macroDefinition.getName().equals("localtab")) continue;
                try {
                    tabInfo = new TabInfo(macroDefinition.getParameter(TITLE_KEY), this.xhtmlUtils.convertStorageToView(macroDefinition.getBodyText(), context));
                    if (macroDefinition.getParameter(ACTIVE_KEY) != null && !activeTabSet) {
                        tabInfo.setActive(true);
                        activeTabSet = true;
                    }
                    if (macroDefinition.getParameter(ID_KEY) != null) {
                        tabInfo.setPaneId(macroDefinition.getParameter(ID_KEY));
                    }
                    if (macroDefinition.getParameter(LEFT_TITLE_TRUNCATION_COUNT_KEY) != null) {
                        tabInfo.setLeftTitleTruncationCount(macroDefinition.getParameter(LEFT_TITLE_TRUNCATION_COUNT_KEY));
                    }
                    if (macroDefinition.getParameter(RIGHT_TITLE_TRUNCATION_COUNT_KEY) != null) {
                        tabInfo.setRightTitleTruncationCount(macroDefinition.getParameter(RIGHT_TITLE_TRUNCATION_COUNT_KEY));
                    }
                    tabs.add(tabInfo);
                }
                catch (Exception e) {
                    throw new MacroExecutionException((Throwable)e);
                }
            }
            if (!activeTabSet && tabs.size() > 0) {
                tabs.get(0).setActive(true);
            }
        }
        return tabs;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

