/*
 * Decompiled with CFR 0.152.
 */
package com.keysight.html.elements.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.PartialList;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.ContentIncludeStack;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderUtils;
import com.keysight.html.elements.helpers.TabInfo;
import com.keysight.html.elements.macros.AuiTabGroup;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuiPagesByLabelTabs
extends AuiTabGroup {
    private static final Logger log = LoggerFactory.getLogger(AuiPagesByLabelTabs.class);
    protected final LabelManager labelManager;
    protected final PageManager pageManager;
    protected final PermissionManager permissionManager;
    protected final Renderer renderer;
    protected final SettingsManager settingsManager;
    protected ConfluenceUser m_currentUser;
    protected static final String ERROR = "Error: ";
    protected static final String NOT_FOUND = "Page Not Found";
    protected static final String ALREADY_INCLUDED = "The page is already rendered";
    protected static final String PAGE_NOT_FOUND = "Unable to find the specified page";
    protected static final String ON_CREATION_DATE = "on-creation-date";
    protected static final String ON_DATE = "on-date";
    protected static final String LABEL = "label";
    protected static final String LIMIT = "limit";
    protected boolean m_showPageInfo;

    @Inject
    public AuiPagesByLabelTabs(LabelManager labelManager, PageManager pageManager, PermissionManager permissionManager, Renderer renderer, VelocityHelperService velocityHelperService, SettingsManager settingsManager, XhtmlContent xhtmlUtils) {
        super(velocityHelperService, xhtmlUtils);
        this.labelManager = labelManager;
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.renderer = renderer;
        this.settingsManager = settingsManager;
        this.m_showPageInfo = true;
    }

    @Override
    protected boolean ShowPageInfo() {
        return this.m_showPageInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ArrayList<TabInfo> getTabs(Map<String, String> parameters, String body, ConversionContext context) throws MacroExecutionException {
        PartialList partialList;
        ArrayList<TabInfo> tabs = new ArrayList<TabInfo>();
        TabInfo tabInfo = null;
        String pageTitle = null;
        String displayTitle = null;
        Page page = null;
        Page thisPage = (Page)context.getEntity();
        boolean i = false;
        boolean activeTabSet = false;
        SimpleDateFormat inputDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date upperBoundDate = null;
        String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        List list = new ArrayList();
        Label label = null;
        this.m_currentUser = AuthenticatedUserThreadLocal.get();
        int startIndex = 0;
        int maxItems = -1;
        boolean hideTab = false;
        if (parameters.containsKey(LIMIT)) {
            try {
                maxItems = Integer.parseInt(parameters.get(LIMIT));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (parameters.containsKey(ON_DATE)) {
            try {
                upperBoundDate = inputDateFormat.parse(parameters.get(ON_DATE));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (upperBoundDate == null && parameters.containsKey(ON_CREATION_DATE)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(thisPage.getCreationDate());
            calendar.add(5, 1);
            upperBoundDate = calendar.getTime();
        }
        if (parameters.containsKey(LABEL) && (label = this.labelManager.getLabel(parameters.get(LABEL))) != null && (partialList = this.labelManager.getContentForLabel(startIndex, maxItems, label)) != null) {
            list = partialList.getList();
        }
        for (ContentEntityObject item : list) {
            try {
                hideTab = false;
                page = (Page)item;
                Page boundedPage = this.GetLatestVersionBeforeDate(upperBoundDate, page);
                displayTitle = page.getTitle();
                if (ContentIncludeStack.contains((ContentEntityObject)page)) {
                    tabInfo = new TabInfo(displayTitle, RenderUtils.blockError((String)"Error:  The page is already rendered", (String)""));
                } else {
                    ContentIncludeStack.push((ContentEntityObject)page);
                    try {
                        DefaultConversionContext childPageContext = new DefaultConversionContext((RenderContext)new PageContext((ContentEntityObject)page, context.getPageContext()));
                        if (this.permissionManager.hasPermission(this.m_currentUser, Permission.VIEW, (Object)boundedPage)) {
                            tabInfo = new TabInfo(displayTitle, this.renderer.render(boundedPage.getBodyAsString(), (ConversionContext)childPageContext));
                        } else {
                            hideTab = true;
                            tabInfo = new TabInfo("No View Permission", RenderUtils.blockError((String)"Error:  You do not have permissions to view this content.", (String)""));
                        }
                        tabInfo.setCreationDate(boundedPage.getLastModificationDate());
                        tabInfo.setAuthorFullName(boundedPage.getLastModifierName());
                        tabInfo.setPageUrl(baseUrl + page.getUrlPath());
                        ConfluenceUser author = boundedPage.getLastModifier();
                        if (author != null) {
                            tabInfo.setAuthorUserName(boundedPage.getLastModifier().getName());
                        }
                    }
                    finally {
                        ContentIncludeStack.pop();
                    }
                }
                if (!activeTabSet) {
                    tabInfo.setActive(true);
                    activeTabSet = true;
                }
                if (parameters.containsKey("ltrunc")) {
                    tabInfo.setLeftTitleTruncationCount(parameters.get("ltrunc"));
                }
                if (parameters.containsKey("rtrunc")) {
                    tabInfo.setRightTitleTruncationCount(parameters.get("rtrunc"));
                }
                if (hideTab) continue;
                tabs.add(tabInfo);
            }
            catch (Exception exception) {
                tabInfo = new TabInfo(pageTitle, RenderUtils.blockError((String)("Error: Unable to convert content entity object to a page. Exception message " + exception.toString()), (String)""));
                tabInfo.setActive(true);
                activeTabSet = true;
                tabs.add(tabInfo);
            }
        }
        return tabs;
    }

    protected Page GetLatestVersionBeforeDate(Date upperBoundDate, Page originalPage) {
        AbstractPage page = this.pageManager.getAbstractPage(originalPage.getLatestVersionId());
        SimpleDateFormat printFormat = new SimpleDateFormat("yyyy-MM-dd");
        boolean doSearch = true;
        boolean i = false;
        if (upperBoundDate != null) {
            while (doSearch && page.getLastModificationDate().after(upperBoundDate)) {
                int versionNumber = page.getPreviousVersion();
                if (versionNumber > 0) {
                    page = this.pageManager.getPageByVersion(page, versionNumber);
                    continue;
                }
                doSearch = false;
            }
        }
        return (Page)page;
    }

    @Override
    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }
}

