/*
 * Decompiled with CFR 0.152.
 */
package com.keysight.html.elements.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.renderer.v2.RenderUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkToWindow
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(LinkToWindow.class);
    public static final String PAGE_KEY = "page";
    public static final String LINK_TEXT_KEY = "link-text";
    protected final PageManager pageManager;
    protected final Renderer renderer;
    protected final SettingsManager settingsManager;
    protected final VelocityHelperService velocityHelperService;

    public LinkToWindow(PageManager pageManager, SettingsManager settingsManager, Renderer renderer, VelocityHelperService velocityHelperService) {
        this.pageManager = pageManager;
        this.settingsManager = settingsManager;
        this.renderer = renderer;
        this.velocityHelperService = velocityHelperService;
    }

    public String execute(Map<String, String> parameters, String body, ConversionContext context) throws MacroExecutionException {
        String template = "/com/keysight/html-elements/templates/link-to-window.vm";
        Map velocityContext = this.velocityHelperService.createDefaultVelocityContext();
        String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        String url = null;
        String spaceKey = null;
        String pageTitle = null;
        Page page = null;
        if (!parameters.containsKey(PAGE_KEY)) {
            return RenderUtils.blockError((String)"No URL or Page specified", (String)"");
        }
        if (parameters.get(PAGE_KEY).matches("http.*")) {
            url = parameters.get(PAGE_KEY);
        } else {
            if (parameters.get(PAGE_KEY).matches(".*:.*")) {
                String[] pageParts = parameters.get(PAGE_KEY).split(":", 2);
                spaceKey = pageParts[0];
                pageTitle = pageParts[1];
            } else {
                spaceKey = context.getSpaceKey();
                pageTitle = parameters.get(PAGE_KEY);
            }
            page = this.pageManager.getPage(spaceKey, pageTitle);
            if (page == null) {
                return RenderUtils.blockError((String)("Page \"" + parameters.get(PAGE_KEY) + "\" not found"), (String)"");
            }
            url = baseUrl + page.getUrlPath();
        }
        velocityContext.put("url", url);
        if (parameters.containsKey(LINK_TEXT_KEY)) {
            velocityContext.put("url-text", parameters.get(LINK_TEXT_KEY));
        } else if (page != null) {
            velocityContext.put("url-text", page.getTitle());
        } else {
            velocityContext.put("url-text", url);
        }
        return this.velocityHelperService.getRenderedTemplate(template, velocityContext);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

