/*
 * Decompiled with CFR 0.152.
 */
package com.keysight.html.elements.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.keysight.html.elements.macros.AuiButton;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuiSplitButton
extends AuiButton {
    private static final Logger log = LoggerFactory.getLogger(AuiSplitButton.class);

    public AuiSplitButton(AttachmentManager attachmentManager, PageManager pageManager, SettingsManager settingsManager, SpaceManager spaceManager, VelocityHelperService velocityHelperService) {
        super(attachmentManager, pageManager, settingsManager, spaceManager, velocityHelperService);
    }

    @Override
    public String execute(Map<String, String> parameters, String body, ConversionContext context) throws MacroExecutionException {
        String template = "/com/keysight/html-elements/templates/aui-split-button.vm";
        Map velocityContext = this.velocityHelperService.createDefaultVelocityContext();
        if (parameters.containsKey("create-button-group") || this.createButtonGroup()) {
            velocityContext.put("create-button-group", "true");
        }
        String[] parts = this.resolveUrlAndText(parameters, context);
        velocityContext.put("button-url", parts[0]);
        velocityContext.put("button-text", parts[1]);
        body = body.trim();
        if (!body.matches("<ul.*") || !body.matches(".*</ul>")) {
            body = "<ul class=\"aui-list-truncate\"><li><a href=\"#\">Improper body.  Needs to be a single unordered (bullet) list of anchors</li></ul>";
        } else {
            body.replaceFirst("<ul>", "<ul class=\"aui-list-truncate\">");
        }
        velocityContext.put("dropdown-menu-id", this.generateId());
        velocityContext.put("renderedBodyHtml", body);
        return this.velocityHelperService.getRenderedTemplate(template, velocityContext);
    }

    @Override
    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }
}

