/*
 * Decompiled with CFR 0.152.
 */
package com.keysight.html.elements.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.ContentIncludeStack;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.user.User;
import com.keysight.html.elements.helpers.TabInfo;
import com.keysight.html.elements.macros.AuiTabGroup;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class AuiPagesTabs
extends AuiTabGroup {
    private static final Logger log = LoggerFactory.getLogger(AuiPagesTabs.class);
    protected final PageManager pageManager;
    protected final PermissionManager permissionManager;
    protected final Renderer renderer;
    protected final SettingsManager settingsManager;
    protected ConfluenceUser m_currentUser;
    protected static final String ERROR = "Error: ";
    protected static final String NOT_FOUND = "Page Not Found";
    protected static final String ALREADY_INCLUDED = "The page is already rendered";
    protected static final String PAGE_NOT_FOUND = "Unable to find the specified page";
    protected static final String ON_CREATION_DATE = "on-creation-date";
    protected static final String ON_DATE = "on-date";
    protected static final String HIDE_NOT_PERMITTED_TABS = "hide-not-permitted-tabs";
    protected boolean m_showPageInfo;

    public AuiPagesTabs(PageManager pageManager, PermissionManager permissionManager, Renderer renderer, VelocityHelperService velocityHelperService, SettingsManager settingsManager, XhtmlContent xhtmlUtils) {
        super(velocityHelperService, xhtmlUtils);
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.renderer = renderer;
        this.settingsManager = settingsManager;
        this.m_showPageInfo = true;
    }

    @Override
    protected boolean ShowPageInfo() {
        return this.m_showPageInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected ArrayList<TabInfo> getTabs(Map<String, String> parameters, String body, ConversionContext context) throws MacroExecutionException {
        tabs = new ArrayList<TabInfo>();
        tabInfo = null;
        pageTitle = null;
        spaceKey = null;
        displayTitle = null;
        page = null;
        thisPage = (Page)context.getEntity();
        i = 0;
        activeTabSet = false;
        inputDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        upperBoundDate = null;
        baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        this.m_currentUser = AuthenticatedUserThreadLocal.get();
        hideTab = false;
        if (parameters.containsKey("on-date")) {
            try {
                upperBoundDate = inputDateFormat.parse(parameters.get("on-date"));
            }
            catch (Exception var20_17) {
                // empty catch block
            }
        }
        if (upperBoundDate == null && parameters.containsKey("on-creation-date")) {
            calendar = Calendar.getInstance();
            calendar.setTime(thisPage.getCreationDate());
            calendar.add(5, 1);
            upperBoundDate = calendar.getTime();
        }
        if (!(body = body.trim()).matches("<ul.*") || !body.matches(".*</ul>")) {
            body = "<ul class=\"aui-list-truncate\"><li><a href=\"#\">Improper body.  Needs to be a single unordered (bullet) list of anchors to internal confluence pages.</li></ul>";
        } else {
            try {
                documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                inputSource = new InputSource();
                inputSource.setCharacterStream(new StringReader(body));
                document = documentBuilder.parse(inputSource);
                document.getDocumentElement().normalize();
                anchors = document.getElementsByTagName("ac:link");
                for (i = 0; i < anchors.getLength(); ++i) {
                    hideTab = false;
                    node = anchors.item(i);
                    page = null;
                    spaceKey = context.getSpaceKey();
                    if (node.getNodeType() != 1) continue;
                    element = (Element)node;
                    pageElements = element.getElementsByTagName("ri:page");
                    if (pageElements.getLength() > 0) {
                        pageElement = (Element)pageElements.item(0);
                        if (pageElement != null && pageElement.hasAttribute("ri:content-title")) {
                            if (pageElement.hasAttribute("ri:space-key")) {
                                spaceKey = pageElement.getAttribute("ri:space-key");
                            }
                            pageTitle = pageElement.getAttribute("ri:content-title");
                            page = this.pageManager.getPage(spaceKey, pageTitle);
                        } else {
                            pageTitle = "Unknown";
                            page = null;
                        }
                    }
                    if (page != null) {
                        boundedPage = this.GetLatestVersionBeforeDate(upperBoundDate, page);
                        displayTitle = page.getTitle();
                        plainTextElements = element.getElementsByTagName("ac:plain-text-link-body");
                        if (plainTextElements.getLength() > 0 && (plainTextElement = (Element)plainTextElements.item(0)) != null) {
                            displayTitle = plainTextElement.getTextContent();
                        }
                        if (ContentIncludeStack.contains(page)) {
                            tabInfo = new TabInfo(displayTitle, RenderUtils.blockError((String)"Error:  The page is already rendered", (String)""));
                        } else {
                            ContentIncludeStack.push(page);
                            try {
                                childPageContext = new DefaultConversionContext((RenderContext)new PageContext((ContentEntityObject)page, context.getPageContext()));
                                if (this.permissionManager.hasPermission((User)this.m_currentUser, Permission.VIEW, (Object)boundedPage)) {
                                    tabInfo = new TabInfo(displayTitle, this.renderer.render(boundedPage.getBodyAsString(), (ConversionContext)childPageContext));
                                } else {
                                    tabInfo = new TabInfo(displayTitle, RenderUtils.blockError((String)("Error:  You do not have permissions to view the page \"" + displayTitle + "\"."), (String)""));
                                    if (parameters.containsKey("hide-not-permitted-tabs")) {
                                        hideTab = true;
                                    }
                                }
                                tabInfo.setCreationDate(boundedPage.getLastModificationDate());
                                tabInfo.setAuthorFullName(boundedPage.getLastModifierName());
                                tabInfo.setPageUrl(baseUrl + page.getUrlPath());
                                author = boundedPage.getLastModifier();
                                if (author == null) ** GOTO lbl84
                                tabInfo.setAuthorUserName(boundedPage.getLastModifier().getName());
                            }
                            finally {
                                ContentIncludeStack.pop();
                            }
                        }
                    } else {
                        tabInfo = new TabInfo(pageTitle, RenderUtils.blockError((String)"Error:  Unable to find the specified page", (String)""));
                    }
lbl84:
                    // 4 sources

                    if (hideTab) continue;
                    if (!activeTabSet) {
                        tabInfo.setActive(true);
                        activeTabSet = true;
                    }
                    tabs.add(tabInfo);
                }
            }
            catch (Exception exception) {
                tabInfo = new TabInfo(pageTitle, RenderUtils.blockError((String)("Error: Unable to parse body.  It should be a bulleted list of links to Confluence pages. Exception message " + exception.toString()), (String)""));
                if (!activeTabSet) {
                    tabInfo.setActive(true);
                    activeTabSet = true;
                }
                tabs.add(tabInfo);
            }
        }
        return tabs;
    }

    protected Page GetLatestVersionBeforeDate(Date upperBoundDate, Page originalPage) {
        AbstractPage page = this.pageManager.getAbstractPage(originalPage.getLatestVersionId());
        SimpleDateFormat printFormat = new SimpleDateFormat("yyyy-MM-dd");
        boolean doSearch = true;
        boolean i = false;
        if (upperBoundDate != null) {
            while (doSearch && page.getLastModificationDate().after(upperBoundDate)) {
                int versionNumber = page.getPreviousVersion();
                if (versionNumber > 0) {
                    page = this.pageManager.getPageByVersion(page, versionNumber);
                    continue;
                }
                doSearch = false;
            }
        }
        return (Page)page;
    }

    @Override
    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }
}

