/*
 * Decompiled with CFR 0.152.
 */
package com.keysight.html.elements.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.ContentIncludeStack;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.user.User;
import com.keysight.html.elements.helpers.TabInfo;
import com.keysight.html.elements.macros.AuiTabGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuiChildTabs
extends AuiTabGroup {
    private static final Logger log = LoggerFactory.getLogger(AuiChildTabs.class);
    protected final PageManager pageManager;
    protected final PermissionManager permissionManager;
    protected final Renderer renderer;
    protected ConfluenceUser m_currentUser;
    protected static final String ROOT_PAGE_KEY = "root";
    protected static final String ERROR = "Error: ";
    protected static final String NOT_FOUND = "Page Not Found";
    protected static final String ALREADY_INCLUDED = "The page is already rendered";
    protected static final String REVERSE = "reverse";

    public AuiChildTabs(PageManager pageManager, PermissionManager permissionManager, Renderer renderer, VelocityHelperService velocityHelperService, XhtmlContent xhtmlUtils) {
        super(velocityHelperService, xhtmlUtils);
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.renderer = renderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ArrayList<TabInfo> getTabs(Map<String, String> parameters, String body, ConversionContext context) throws MacroExecutionException {
        ArrayList<TabInfo> tabs;
        block19: {
            tabs = new ArrayList<TabInfo>();
            TabInfo tabInfo = null;
            String[] pageParts = new String[2];
            String pageTitle = null;
            String spaceKey = null;
            Page rootPage = null;
            Page thisPage = (Page)context.getEntity();
            this.m_currentUser = AuthenticatedUserThreadLocal.get();
            boolean activeTabSet = false;
            boolean hideTab = false;
            if (parameters.containsKey(ROOT_PAGE_KEY)) {
                if (parameters.get(ROOT_PAGE_KEY).matches(".*:.*")) {
                    pageParts = parameters.get(ROOT_PAGE_KEY).split(":", 2);
                    spaceKey = pageParts[0];
                    pageTitle = pageParts[1];
                } else {
                    spaceKey = context.getSpaceKey();
                    pageTitle = parameters.get(ROOT_PAGE_KEY);
                }
                rootPage = this.pageManager.getPage(spaceKey, pageTitle);
            } else {
                rootPage = (Page)context.getEntity();
            }
            ContentIncludeStack.push((ContentEntityObject)((Page)context.getEntity()));
            ContentIncludeStack.push((ContentEntityObject)rootPage);
            try {
                if (rootPage == null || !rootPage.hasChildren()) break block19;
                List childPages = rootPage.getSortedChildren();
                for (Page childPage : childPages) {
                    hideTab = false;
                    if (ContentIncludeStack.contains((ContentEntityObject)childPage)) {
                        tabInfo = new TabInfo(childPage.getTitle(), RenderUtils.blockError((String)"Error:  The page is already rendered", (String)""));
                    } else {
                        ContentIncludeStack.push((ContentEntityObject)childPage);
                        try {
                            DefaultConversionContext childPageContext = new DefaultConversionContext((RenderContext)new PageContext((ContentEntityObject)childPage, context.getPageContext()));
                            if (this.permissionManager.hasPermission((User)this.m_currentUser, Permission.VIEW, (Object)childPage)) {
                                tabInfo = new TabInfo(childPage.getTitle(), this.renderer.render(childPage.getBodyAsString(), (ConversionContext)childPageContext));
                            } else {
                                hideTab = true;
                                tabInfo = new TabInfo("No View Permission", RenderUtils.blockError((String)("Error:  You do not have permissions to view page \"" + childPage.getTitle() + "\" in space \"" + childPage.getSpace().getName() + "\"."), (String)""));
                            }
                        }
                        finally {
                            ContentIncludeStack.pop();
                        }
                    }
                    if (!hideTab && !activeTabSet) {
                        tabInfo.setActive(true);
                        activeTabSet = true;
                    }
                    if (parameters.containsKey("ltrunc")) {
                        tabInfo.setLeftTitleTruncationCount(parameters.get("ltrunc"));
                    }
                    if (parameters.containsKey("rtrunc")) {
                        tabInfo.setRightTitleTruncationCount(parameters.get("rtrunc"));
                    }
                    if (hideTab) continue;
                    tabs.add(tabInfo);
                }
            }
            finally {
                ContentIncludeStack.pop();
                ContentIncludeStack.pop();
            }
        }
        if (parameters.containsKey(REVERSE)) {
            Collections.reverse(tabs);
        }
        return tabs;
    }

    @Override
    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }
}

