/*
 * Decompiled with CFR 0.152.
 */
package com.keysight.html.elements.helpers;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NavigationPageResolver {
    private static final Logger log = LoggerFactory.getLogger(NavigationPageResolver.class);
    protected final PageManager pageManager;
    protected final PermissionManager permissionManager;
    protected final SettingsManager settingsManager;
    protected final SpaceManager spaceManager;
    public static final String SHOW_TITLE_KEY = "show-title";
    public static final String PREVIOUS_BUTTON_TEXT_KEY = "previous-button-text";
    public static final String PARENT_BUTTON_TEXT_KEY = "parent-button-text";
    public static final String NEXT_BUTTON_TEXT_KEY = "next-button-text";

    public NavigationPageResolver(PageManager pageManager, PermissionManager permissionManager, SettingsManager settingsManager, SpaceManager spaceManager) {
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.settingsManager = settingsManager;
        this.spaceManager = spaceManager;
    }

    public String[] resolveUrlAndTextForNextPage(Map<String, String> parameters, ConversionContext context) {
        String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        String[] parts = new String[]{};
        Page nextPage = null;
        ContentEntityObject contentEntityObject = context.getEntity();
        if (contentEntityObject instanceof Page) {
            Page page = (Page)contentEntityObject;
            nextPage = this.getFirstVisibleChildPage(page);
            if (nextPage == null) {
                nextPage = this.getNextVisibleSiblingOrParentPage(page);
            }
            if (nextPage != null) {
                parts = new String[]{baseUrl + nextPage.getUrlPath(), nextPage.getTitle()};
                if (parameters.containsKey(NEXT_BUTTON_TEXT_KEY)) {
                    parts[1] = parameters.get(NEXT_BUTTON_TEXT_KEY).replace("$title", parts[1]);
                } else if (!parameters.containsKey(SHOW_TITLE_KEY)) {
                    parts[1] = ">";
                }
            }
        }
        return parts;
    }

    public String[] resolveUrlAndTextForPreviousPage(Map<String, String> parameters, ConversionContext context) {
        String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        String[] parts = new String[]{};
        Page previousPage = null;
        ContentEntityObject contentEntityObject = context.getEntity();
        if (contentEntityObject instanceof Page) {
            Page page = (Page)contentEntityObject;
            if (!page.isRootLevel() && !page.isHomePage()) {
                previousPage = this.getPreviousVisibleSiblingOrParentPage(page);
            }
            if (previousPage != null) {
                parts = new String[]{baseUrl + previousPage.getUrlPath(), previousPage.getTitle()};
                if (parameters.containsKey(PREVIOUS_BUTTON_TEXT_KEY)) {
                    parts[1] = parameters.get(PREVIOUS_BUTTON_TEXT_KEY).replace("$title", parts[1]);
                } else if (!parameters.containsKey(SHOW_TITLE_KEY)) {
                    parts[1] = "<";
                }
            }
        }
        return parts;
    }

    public String[] resolveUrlAndTextForParentPage(Map<String, String> parameters, ConversionContext context) {
        String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        String[] parts = new String[]{};
        Page parentPage = null;
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        ContentEntityObject contentEntityObject = context.getEntity();
        if (contentEntityObject instanceof Page) {
            Page page = (Page)contentEntityObject;
            if (!page.isRootLevel() && !page.isHomePage()) {
                parentPage = this.permissionManager.hasPermission((User)currentUser, Permission.VIEW, (Object)page.getParent()) ? page.getParent() : this.getPreviousVisibleSiblingOrParentPage(page.getParent());
            }
            if (parentPage != null) {
                parts = new String[]{baseUrl + parentPage.getUrlPath(), parentPage.getTitle()};
                if (parameters.containsKey(PARENT_BUTTON_TEXT_KEY)) {
                    parts[1] = parameters.get(PARENT_BUTTON_TEXT_KEY).replace("$title", parts[1]);
                } else if (!parameters.containsKey(SHOW_TITLE_KEY)) {
                    parts[1] = "^";
                }
            }
        }
        return parts;
    }

    private Page getFirstVisibleChildPage(Page page) {
        Page firstVisibleChildPage = null;
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (page.hasChildren()) {
            for (Page childPage : page.getSortedChildren()) {
                if (!this.permissionManager.hasPermission((User)currentUser, Permission.VIEW, (Object)childPage)) continue;
                firstVisibleChildPage = childPage;
                break;
            }
        }
        return firstVisibleChildPage;
    }

    private Page getNextVisibleSiblingOrParentPage(Page page) {
        Page nextVisiblePage = null;
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (!page.isRootLevel() && !page.isHomePage()) {
            List siblings = page.getParent().getSortedChildren();
            block0: for (int i = 0; i < siblings.size() - 1; ++i) {
                Page siblingPage = (Page)siblings.get(i);
                if (!this.permissionManager.hasPermission((User)currentUser, Permission.VIEW, (Object)siblingPage) || !page.equals((Object)siblingPage)) continue;
                for (int j = i + 1; j < siblings.size(); ++j) {
                    Page nextSibling = (Page)siblings.get(j);
                    if (!this.permissionManager.hasPermission((User)currentUser, Permission.VIEW, (Object)nextSibling)) continue;
                    nextVisiblePage = nextSibling;
                    break block0;
                }
                break;
            }
            if (nextVisiblePage == null) {
                nextVisiblePage = this.getNextVisibleSiblingOrParentPage(page.getParent());
            }
        }
        return nextVisiblePage;
    }

    private Page getPreviousVisibleSiblingOrParentPage(Page page) {
        Page previousVisiblePage = null;
        Page visiblePageFromLastIteration = null;
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        List siblings = page.getParent().getSortedChildren();
        for (int i = 1; i < siblings.size(); ++i) {
            Page siblingPage = (Page)siblings.get(i);
            if (!this.permissionManager.hasPermission((User)currentUser, Permission.VIEW, (Object)siblingPage)) continue;
            if (page.equals((Object)siblingPage)) {
                previousVisiblePage = visiblePageFromLastIteration;
                break;
            }
            visiblePageFromLastIteration = siblingPage;
        }
        if (previousVisiblePage == null) {
            previousVisiblePage = this.permissionManager.hasPermission((User)currentUser, Permission.VIEW, (Object)page.getParent()) ? page.getParent() : this.getPreviousVisibleSiblingOrParentPage(page.getParent());
        }
        return previousVisiblePage;
    }
}

