/*
 * Decompiled with CFR 0.152.
 */
package com.keysight.database.rest;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.keysight.database.helpers.ConnectionProfile;
import com.keysight.database.helpers.PluginConfigManager;
import com.keysight.database.macros.DatabaseQuery;
import com.keysight.database.macros.MacroResultsCache;
import com.keysight.database.rest.RestResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Path(value="/")
public class RestService {
    private static final Logger log = LoggerFactory.getLogger(RestService.class);
    private static ResourceBundle literals;
    private final CacheManager cacheManager;
    private final ClusterManager clusterManager;
    private final PluginConfigManager pluginConfigManager;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final SettingsManager settingsManager;
    private final TransactionTemplate transactionTemplate;
    private final UserManager userManager;
    private final UserAccessor userAccessor;
    private final VelocityHelperService velocityHelperService;
    private Cache<String, String> databaseQueryDataCache = null;
    private Cache<String, String> databaseQueryCreationTimeCache = null;
    private Cache<String, String> macroResultsCacheDataCache = null;
    private Cache<String, String> macroResultsCacheCreationTimeCache = null;

    public RestService(CacheManager cacheManager, ClusterManager clusterManager, PluginConfigManager pluginConfigManager, PluginSettingsFactory pluginSettingsFactory, SettingsManager settingsManager, TransactionTemplate transactionTemplate, UserManager userManger, UserAccessor userAccessor, VelocityHelperService velocityHelperService) {
        this.cacheManager = cacheManager;
        this.clusterManager = clusterManager;
        this.pluginConfigManager = pluginConfigManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.settingsManager = settingsManager;
        this.transactionTemplate = transactionTemplate;
        this.userAccessor = userAccessor;
        this.userManager = userManger;
        this.velocityHelperService = velocityHelperService;
        literals = ResourceBundle.getBundle("/com/keysight/database/i18n/database");
        this.databaseQueryDataCache = cacheManager.getCache(DatabaseQuery.class.getName() + "data.cache");
        this.databaseQueryCreationTimeCache = cacheManager.getCache(DatabaseQuery.class.getName() + ".create-time.cache");
        this.macroResultsCacheDataCache = cacheManager.getCache(MacroResultsCache.class.getName() + "data.cache");
        this.macroResultsCacheCreationTimeCache = cacheManager.getCache(MacroResultsCache.class.getName() + ".create-time.cache");
    }

    @GET
    @Path(value="/cache/macroResultsCache/clear/{macroId}")
    @Produces(value={"application/json"})
    @AnonymousAllowed
    public Response clearIdFromMacroResultsCacheCache(@Context HttpServletRequest request, @PathParam(value="macroId") String macroId) {
        if (this.clusterManager.isClustered()) {
            for (ClusterNodeInformation nodeInformation : this.clusterManager.getAllNodesInformation()) {
                try {
                    String clusterId = nodeInformation.getAnonymizedNodeIdentifier() + ":";
                    this.macroResultsCacheDataCache.remove((Object)(clusterId + macroId));
                    this.macroResultsCacheCreationTimeCache.remove((Object)(clusterId + macroId));
                }
                catch (Exception exception) {}
            }
        } else {
            try {
                this.macroResultsCacheDataCache.remove((Object)macroId);
                this.macroResultsCacheCreationTimeCache.remove((Object)macroId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Response.noContent().build();
    }

    @GET
    @Path(value="/cache/databaseQuery/clear/{macroId}")
    @Produces(value={"application/json"})
    @AnonymousAllowed
    public Response clearIdFromDatabaseQueryCache(@Context HttpServletRequest request, @PathParam(value="macroId") String macroId) {
        try {
            this.databaseQueryDataCache.remove((Object)macroId);
            this.databaseQueryCreationTimeCache.remove((Object)macroId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Response.noContent().build();
    }

    @GET
    @Path(value="help/database-query")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response databaseQueryHelp() {
        String title = "Database Query";
        String bodyTemplate = "/com/keysight/database/templates/database-query-help.vm";
        return this.getMacroHelp(title, bodyTemplate);
    }

    @GET
    @Path(value="help/macro-result-cache")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response macroResultCacheHelp() {
        String title = "Macro Result Cache";
        String bodyTemplate = "/com/keysight/database/templates/macro-result-cache-help.vm";
        return this.getMacroHelp(title, bodyTemplate);
    }

    @GET
    @Path(value="config/limits")
    @Produces(value={"application/json"})
    public Response getQueryLimits(@Context HttpServletRequest request) {
        this.pluginConfigManager.loadFromStorage();
        HashMap<String, String> limitsMap = new HashMap<String, String>();
        limitsMap.put("rowLimit", this.pluginConfigManager.getRowLimitValue());
        limitsMap.put("timeLimit", this.pluginConfigManager.getTimeoutLimitValue());
        return Response.ok((Object)this.transactionTemplate.execute(() -> limitsMap)).build();
    }

    @GET
    @Path(value="config/profiles")
    @Produces(value={"application/json"})
    public Response getConnectionProfiles(@Context HttpServletRequest request) {
        return Response.ok((Object)this.transactionTemplate.execute(() -> this.generateProfileArray(request))).build();
    }

    @GET
    @Path(value="config/profiles/{name}")
    @Produces(value={"application/json"})
    public Response getSingleProfile(@Context HttpServletRequest request, @PathParam(value="name") String name) {
        for (ConnectionProfile profile : this.generateProfileArray(request)) {
            if (profile.getName() == null || !profile.getName().equals(name)) continue;
            return Response.ok((Object)this.transactionTemplate.execute(() -> profile)).build();
        }
        return Response.status((int)204).entity(this.transactionTemplate.execute(() -> literals.getString("com.keysight.database.api.accessError"))).build();
    }

    @GET
    @Path(value="config/profiles/hasAccess")
    @Produces(value={"application/json"})
    public Response getProfilePermission(@Context HttpServletRequest request) {
        UserKey userKey = this.userManager.getRemoteUserKey(request);
        if (userKey == null) {
            return Response.ok((Object)this.transactionTemplate.execute(() -> false)).build();
        }
        if (this.userManager.isSystemAdmin(userKey)) {
            return Response.ok((Object)this.transactionTemplate.execute(() -> true)).build();
        }
        UserProfile currentProfile = this.userManager.getUserProfile(userKey);
        assert (currentProfile != null);
        String currentUsername = currentProfile.getUsername();
        List currentGroups = this.userAccessor.getGroupNamesForUserName(currentUsername);
        this.pluginConfigManager.loadFromStorage();
        if (this.pluginConfigManager.getAuthorizedUsers().contains(currentUsername)) {
            return Response.ok((Object)this.transactionTemplate.execute(() -> true)).build();
        }
        ArrayList<String> tempList = new ArrayList<String>(this.pluginConfigManager.getAuthorizedGroups());
        tempList.retainAll(currentGroups);
        return Response.ok((Object)this.transactionTemplate.execute(() -> !tempList.isEmpty())).build();
    }

    private Response getMacroHelp(String title, String bodyTemplate) {
        StringBuilder html = new StringBuilder();
        String headerTemplate = "/com/keysight/database/templates/help-header.vm";
        String footerTemplate = "/com/keysight/database/templates/help-footer.vm";
        String fossTemplate = "/com/keysight/database/templates/foss.vm";
        Map velocityContext = this.velocityHelperService.createDefaultVelocityContext();
        velocityContext.put("title", title);
        velocityContext.put("baseUrl", this.settingsManager.getGlobalSettings().getBaseUrl());
        html.append(this.velocityHelperService.getRenderedTemplate(headerTemplate, velocityContext));
        html.append(this.velocityHelperService.getRenderedTemplate(bodyTemplate, velocityContext));
        html.append(this.velocityHelperService.getRenderedTemplate(fossTemplate, velocityContext));
        html.append(this.velocityHelperService.getRenderedTemplate(footerTemplate, velocityContext));
        return Response.ok((Object)new RestResponse(html.toString())).build();
    }

    private List<ConnectionProfile> generateProfileArray(HttpServletRequest request) {
        this.pluginConfigManager.loadFromStorage();
        NodeList profileNodes = this.pluginConfigManager.getProfiles();
        ArrayList<ConnectionProfile> profiles = new ArrayList<ConnectionProfile>();
        for (int i = 0; i < profileNodes.getLength(); ++i) {
            Element profileNode = (Element)profileNodes.item(i);
            ConnectionProfile currentProfile = new ConnectionProfile(profileNode);
            profiles.add(currentProfile);
        }
        UserKey userKey = this.userManager.getRemoteUserKey(request);
        UserProfile currentProfile = this.userManager.getUserProfile(userKey);
        assert (currentProfile != null);
        String currentUsername = currentProfile.getUsername();
        List currentGroups = this.userAccessor.getGroupNamesForUserName(currentUsername);
        Map parameterMap = request.getParameterMap();
        return profiles.stream().filter(profile -> {
            String spaceKey;
            if (parameterMap.containsKey("spaceKey") && !profile.spaceIsAuthorizedToUseProfile(spaceKey = ((String[])parameterMap.get("spaceKey"))[0])) {
                return false;
            }
            if (userKey == null) {
                return false;
            }
            if (this.userManager.isSystemAdmin(userKey)) {
                return true;
            }
            if (profile.universalAccessAllowed()) {
                return true;
            }
            if (profile.getAuthorizedUsers().contains(currentUsername)) {
                return true;
            }
            ArrayList<String> tempList = new ArrayList<String>(profile.getAuthorizedGroups());
            tempList.retainAll(currentGroups);
            return !tempList.isEmpty();
        }).collect(Collectors.toList());
    }
}

